<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class cutOffController extends Controller
{

    //get all cutOffList
    public function getAllCutOffList()
    {
        $cutofflist=DB::table('tblCutOff')->leftjoin('tblinstitutedetails','tblCutOff.iCollegeCode', '=','tblinstitutedetails.iCollegeCode')
        ->select('tblCutOff.*','tblinstitutedetails.sCollegeName')
        ->where('tblCutOff.iBisActive', 1)
        ->get();
        return response()->json(['result'=>'1','data'=>$cutofflist]);
    }


    // get cutoff list by id
    public function getCutOffByid($iId)
    {
        $cutoff = DB::table("tblCutOff")
        ->leftjoin('tblinstitutedetails','tblCutOff.iCollegeCode', '=','tblinstitutedetails.iCollegeCode')
        ->select('tblCutOff.*','tblinstitutedetails.sCollegeName')
        ->where('tblCutOff.iId',$iId)->first();


        if($cutoff){
            return response()->json([
                'result'=>"1",
                'message'=>'Cutoff found',
                'data'=> $cutoff
            ]);
        }
        else{
                return response()->json([
                    'result'=>"5",
                    'message'=>'Cutoff not found'
                ],404);
            }
    }



    // Add Cut off of Institute
    public function addCutOff(Request $request)
    {
        $data = $request->only([
            'sProgram','iCollegeCode', 'sInstituteUniqueID', 'iBranchCode', 'sRound', 'iCourseCode', 
            'sCourseName', 'sQuota','sSeatType','iAIR', 'iSML', 'sUniversityName', 
            'sAutonomyStatus', 'sGendorEducation', 'sMinorityStatus', 'sPercentile', 'sProgram','sRound','sPercentile','iYear','iBisActive', 
            'dtUpdatedDate'
        ]);
        $data['dtUpdatedDate'] = now();
        $dta['iBisActive'] =1;
        $id = DB::table('tblCutOff')->insertGetId($data);

        return response()->json(['result'=>'2','message' => 'Institutes Cut-Off added successfully', 'id' => $id], 201);
    }



    // To add Multiple Cut Off
    public function addMultipleCutOff(Request $request)
    {
        try {
            $institutesData = $request->input('cutofflist', []); 
            $status = $request->input('status'); 
            $year = $request->input('iYear');    
            $program = $request->input('sProgram');
    
            // Validate required fields
            if (empty($institutesData) || !is_array($institutesData)) {
                return response()->json(['result' => '0', 'message' => 'Invalid institute data provided.'], 400);
            }
    
            if (empty($status)) {
                return response()->json(['result' => '0', 'message' => 'Status is required.'], 400);
            }
    
            if (empty($year)) {
                return response()->json(['result' => '0', 'message' => 'Year is required.'], 400);
            }
    
            $currentDate = now();
    
            // Handle `status` logic
            if ($status === 'addall') {
                if (!empty($program)) {
                    DB::table('tblCutOff')
                        ->where('sProgram', $program)
                        ->where('iYear', $year)
                        ->delete();
                } else {
                    DB::table('tblCutOff')
                        ->where('iYear', $year)
                        ->delete();
                }
            }
    
            // Add `year` and `program` to each record
            foreach ($institutesData as &$data) {
                $data['dtUpdatedDate'] = $currentDate; // Timestamp
                $data['iBisActive'] = 1;              // Set active flag
                $data['iYear'] = $year;                // Add the provided year
            }
    
            DB::table('tblCutOff')->insert($institutesData);

    
        return response()->json(['result' => '2', 'message' => 'Cut Off processed successfully.'], 201);
        } catch (\Exception $e) {
            // Log the error and return a failure response
            \Log::error('Error in addMultipleCutOff:', [
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString(),
            ]);
    
            return response()->json(['result' => '0', 'message' => 'An error occurred while processing Cut Off.'], 500);
        }
    }
    



    // Update an existing record
    public function updateCutOffList(Request $request)
    {
        $data = $request->only([
           'iCollegeCode', 'sInstituteUniqueID', 'iBranchCode', 'sRound', 'iCourseCode', 
            'sCourseName', 'sQuota','sSeatType','iAIR', 'iSML', 'sUniversityName', 
            'sAutonomyStatus', 'sGendorEducation', 'sMinorityStatus', 'iNeetMarks', 'sProgram','sRound','sPercentile','iYear','iBisActive', 
            'dtUpdatedDate'
        ]);

        $iId = $request->input('iId');
        $data['dtUpdatedDate']=now();
        $updated = DB::table('tblCutOff')->where('iId', $iId)->update($data);

        if ($updated) {
            return response()->json(['result'=>'3','message' => 'Institute Cut-off updated']);
        } else {
            return response()->json(['message' => 'Institute Cut-off not found'], 404);
        }
    }


    // Delete a record
    public function deleteCutOff($iId)
    {
        $deleted = DB::table('tblCutOff')->where('iId', $iId)->update(['iBisActive' => 0]);
        if ($deleted) {
            return response()->json(['result'=>'2','message' => 'Institute Cut-off deleted']);
        } else {
            return response()->json(['message' => 'Institute Cut-off not found'], 404);
        }
    }
    

    // get cutofflist by pagination
    public function getAllCutOffListbyPage(Request $request)
    {
        try {
            $validatedData = $request->validate([
                'per_page' => 'integer|nullable',
                'current_page' => 'integer|nullable',
            ]);
    
            $perPage = $validatedData['per_page'] ?? 10;
            $currentPage = $validatedData['current_page'] ?? 1;
    
            // Subquery to deduplicate tblinstitutedetails and include other fields
            $subQuery = DB::table('tblinstitutedetails')
                ->select(
                    'iCollegeCode',
                    DB::raw('MAX(sCollegeName) as sCollegeName'),
                    DB::raw('MAX(sStatus) as sStatus'),
                    DB::raw('MAX(sDistrict) as sDistrict'),
                    DB::raw('MAX(sUniversityName) as sUniversityName'),
                    DB::raw('MAX(sAutonomyStatus) as sAutonomyStatus'),
                    DB::raw('MAX(sIntake) as sIntake'),
                    DB::raw('MAX(sPhoneNo) as sPhoneNo'),
                    DB::raw('MAX(imageURL) as imageURL'),
                    DB::raw('MAX(sAddress) as sAddress')
                )
                ->groupBy('iCollegeCode');
    
            // Main query with left join
            $query = DB::table('tblCutOff')
                ->leftJoinSub($subQuery, 'tblinstitutedetails', 'tblCutOff.iCollegeCode', '=', 'tblinstitutedetails.iCollegeCode')
                ->select(
                    'tblCutOff.*',
                    'tblinstitutedetails.sCollegeName',
                    'tblinstitutedetails.sStatus',
                    'tblinstitutedetails.sDistrict',
                    'tblinstitutedetails.sUniversityName',
                    'tblinstitutedetails.sAutonomyStatus',
                    'tblinstitutedetails.sIntake',
                    'tblinstitutedetails.sPhoneNo',
                    'tblinstitutedetails.imageURL',
                    'tblinstitutedetails.sAddress'
                );
    
            // Pagination logic
            $offset = ($currentPage - 1) * $perPage;
            $total = $query->count();
            $colleges = $query->offset($offset)->limit($perPage)->get();
    
            $lastPage = (int) ceil($total / $perPage);
    
            // Return paginated response
            return response()->json([
                'result'=>'1',
                'success' => true,
                'data' => $colleges,
                'current_page' => $currentPage,
                'last_page' => $lastPage,
                'total' => $total,
                'per_page' => $perPage,
                'message' => 'Colleges retrieved successfully.',
            ]);
        } catch (\Exception $e) {
            \Log::error('Error in getAllCutOffListbyPage:', [
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString(),
            ]);
    
            return response()->json([
                'success' => false,
                'message' => 'An error occurred while retrieving colleges.',
            ], 500);
        }
    }
    
    
    
    public function getAllCutOffByFilter(Request $request)
    {
        try {
            // Validate incoming request dynamically
            $validatedData = $request->validate([
                'query' => 'nullable|string',  // Search query
                'per_page' => 'integer|nullable', // Items per page
                'current_page' => 'integer|nullable', // Current page number
                'sortField' => 'nullable|string', // Sort field
                'sortOrder' => 'nullable|string', // Sort order
                'filters' => 'nullable|array', // Filters object
                'filters.program' => 'nullable|array', // Program filters
                'filters.course' => 'nullable|array', // Course filters
                'filters.state' => 'nullable|array', // State filters
                'filters.city' => 'nullable|array', // City filters
                'filters.status' => 'nullable|array', // Status filters
            ]);
    
            // Extract parameters from request
            $query = $validatedData['query'] ?? null;
            $perPage = $validatedData['per_page'] ?? 10;
            $currentPage = $validatedData['current_page'] ?? 1;
            $sortField = $validatedData['sortField'] ?? null;
            $sortOrder = $validatedData['sortOrder'] ?? 'asc'; // Default sort order
            $filters = $validatedData['filters'] ?? [];
    
            // Build query to fetch cut-off data
            $queryBuilder = DB::table('tblCutOff')
                ->leftJoin('tblinstitutedetails', 'tblCutOff.iCollegeCode', '=', 'tblinstitutedetails.iCollegeCode')
                ->select(
                    'tblCutOff.*', // Selecting all columns from tblCutOff
                    'tblinstitutedetails.sCollegeName',
                    'tblinstitutedetails.sStatus as institute_status', // Aliased to avoid ambiguity
                    'tblinstitutedetails.sDistrict',
                    'tblinstitutedetails.sUniversityName',
                    'tblinstitutedetails.sAutonomyStatus',
                    'tblinstitutedetails.sIntake',
                    'tblinstitutedetails.sPhoneNo',
                    'tblinstitutedetails.imageURL',
                    'tblinstitutedetails.sAddress'
                )
                ->where('tblCutOff.iBisActive', 1); // Ensure records are active
    
            // Apply search query if provided
            if (!empty($query)) {
                $searchableColumns = [
                    'tblCutOff.sProgram', 'tblCutOff.sCourseName', 'tblCutOff.iCollegeCode',
                    'tblCutOff.sInstituteUniqueID', 'tblCutOff.sStatus', 'tblinstitutedetails.sDistrict',
                    'tblinstitutedetails.sUniversityName', 'tblinstitutedetails.sAutonomyStatus',
                    'tblinstitutedetails.sCollegeName'
                ];
    
                $queryBuilder->where(function ($q) use ($query, $searchableColumns) {
                    foreach ($searchableColumns as $column) {
                        $q->orWhere($column, 'LIKE', '%' . $query . '%');
                    }
                });
            }
    
            // Apply filters if provided
            if (isset($filters['program']) && !empty($filters['program'])) {
                $queryBuilder->whereIn('tblCutOff.sProgram', $filters['program']);
            }
    
            if (isset($filters['course']) && !empty($filters['course'])) {
                $queryBuilder->whereIn('tblCutOff.sCourseName', $filters['course']);
            }
    
            // Apply state, city, and status filters specifically on tblInstituteDetails
            $queryBuilder->where(function ($q) use ($filters) {
                if (isset($filters['state']) && !empty($filters['state'])) {
                    $q->whereIn('tblinstitutedetails.sState', $filters['state']);
                }
                if (isset($filters['city']) && !empty($filters['city'])) {
                    $q->whereIn('tblinstitutedetails.sDistrict', $filters['city']);
                }
                if (isset($filters['status']) && !empty($filters['status'])) {
                    $q->whereIn('tblinstitutedetails.sStatus', $filters['status']);
                }
            });
    
            // Apply sorting if sortField and sortOrder are provided
            if ($sortField) {
                $queryBuilder->orderBy($sortField, $sortOrder);
            } else {
                // Default sorting (if no field is specified)
                $queryBuilder->orderBy('tblCutOff.iCollegeCode', 'asc');
            }
    
            // Pagination logic
            $total = $queryBuilder->count(); // Get total count before pagination
            $cutOffList = $queryBuilder->offset(($currentPage - 1) * $perPage)->limit($perPage)->get(); // Fetch the paginated results
    
            // Calculate the last page
            $lastPage = (int) ceil($total / $perPage);
    
            // Return the paginated response
            return response()->json([
                'success' => true,
                'data' => $cutOffList,
                'current_page' => $currentPage,
                'last_page' => $lastPage,
                'total' => $total,
                'per_page' => $perPage,
                'message' => 'Cut-off data retrieved successfully.',
            ]);
        } catch (\Exception $e) {
            \Log::error('Error in getAllCutOffByFilter:', [
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString(),
            ]);
    
            return response()->json([
                'success' => false,
                'message' => 'An error occurred while retrieving cut-off data.',
            ], 500);
        }
    }
    
    // get distinct states
    public function getStatesByCutOff()
    {
        try {
            $results = DB::table('tblCutOff')
                ->leftJoin('tblinstitutedetails', 'tblCutOff.iCollegeCode', '=', 'tblinstitutedetails.iCollegeCode')
                ->select(
                    DB::raw('DISTINCT tblinstitutedetails.sState AS state'), 
                    DB::raw('COUNT(tblCutOff.iCollegeCode) AS count') 
                )
                ->where('tblCutOff.iBisActive', 1)
                ->whereNotNull('tblinstitutedetails.sState') 
                ->groupBy('tblinstitutedetails.sState') 
                ->get();

            return response()->json($results);
        } catch (\Exception $e) {
            \Log::error('Error in getStates:', [
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString(),
            ]);

            return response()->json([
                'success' => false,
                'message' => 'An error occurred while retrieving states.',
            ], 500);
        }
    }



    // get distinct cities
    public function getDistrictsByState(Request $request)
    {
        try {
            // Validate the incoming request
            $request->validate([
                'states' => 'nullable|array', 
                'states.*' => 'string',        
            ]);
    
            $states = $request->input('states');
    
            // Build the query
            $query = DB::table('tblCutOff')
                ->leftJoin('tblinstitutedetails', 'tblCutOff.iCollegeCode', '=', 'tblinstitutedetails.iCollegeCode')
                ->select(
                    'tblinstitutedetails.sDistrict',
                    DB::raw('COUNT(tblCutOff.iCollegeCode) as count') 
                )
                ->where('tblCutOff.iBisActive', 1) 
                ->whereNotNull('tblinstitutedetails.sDistrict') 
                ->groupBy('tblinstitutedetails.sState', 'tblinstitutedetails.sDistrict'); 
    
            if (!empty($states)) {
                $query->whereIn('tblinstitutedetails.sState', $states);
            }
    
            $result = $query->get();
    
            return response()->json([
                'success' => true,
                'data' => $result,
                'message' => 'Districts by state retrieved successfully.',
            ]);
        } catch (\Exception $e) {
            // Log any errors that occur
            \Log::error('Error in getDistrictsByState:', [
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString(),
            ]);
    
            return response()->json([
                'success' => false,
                'message' => 'An error occurred while retrieving districts by state.',
            ], 500);
        }
    }
    



    // get distinct programs
    public function getProgramsByCutOffFilter(Request $request)
    {
        try {
            $request->validate([
                'filter.selectedCities' => 'nullable|array',
                'filter.selectedCities.*' => 'string', 
                'filter.selectedStates' => 'nullable|array',
                'filter.selectedStates.*' => 'string',
            ]);
    
            $cities = $request->input('filter.selectedCities', []); 
            $states = $request->input('filter.selectedStates', []);
    
            $query = DB::table('tblCutOff')
                ->leftJoin('tblinstitutedetails', 'tblCutOff.iCollegeCode', '=', 'tblinstitutedetails.iCollegeCode') 
                ->select('tblCutOff.sProgram', DB::raw('COUNT(tblCutOff.iCollegeCode) AS count')) 
                ->where('tblCutOff.iBisActive', 1) 
                ->whereNotNull('tblCutOff.sProgram') 
                ->groupBy('tblCutOff.sProgram');
    
            if (!empty($states)) {
                $query->whereIn('tblinstitutedetails.sState', $states); // Filter by state
            }
    
            if (!empty($cities)) {
                $query->whereIn('tblinstitutedetails.sDistrict', $cities); // Filter by district (city)
            }
    
            $result = $query->get();
    
            return response()->json([
                'success' => true,
                'data' => $result, // The filtered program data
                'message' => 'Programs retrieved successfully based on the filters.',
            ]);
        } catch (\Exception $e) {
            // Log the error if an exception occurs
            \Log::error('Error in getProgramsByCutOffFilter:', [
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString(), // Capture the stack trace for debugging
            ]);
    
            // Return a JSON response indicating failure
            return response()->json([
                'success' => false,
                'message' => 'An error occurred while retrieving programs.',
            ], 500);
        }
    }
    
    
    // get  courses by filter
    public function getCoursesByCutOffFilter(Request $request)
    {
        try {
          
            $request->validate([
                'filter.selectedCities' => 'nullable|array',
                'filter.selectedCities.*' => 'string', 
                'filter.selectedStates' => 'nullable|array',
                'filter.selectedStates.*' => 'string', 
                'filter.selectedPrograms' => 'nullable|array',
                'filter.selectedPrograms.*' => 'string', 
            ]);
    
            // Extract filters from the request
            $cities = $request->input('filter.selectedCities', []);
            $states = $request->input('filter.selectedStates', []); 
            $programs = $request->input('filter.selectedPrograms', []); 
    
            $query = DB::table('tblCutOff')
                ->leftJoin('tblinstitutedetails', 'tblCutOff.iCollegeCode', '=', 'tblinstitutedetails.iCollegeCode') 
                ->select('tblCutOff.sCourseName', DB::raw('COUNT(tblCutOff.iCollegeCode) AS count')) 
                ->where('tblCutOff.iBisActive', 1) 
                ->whereNotNull('tblCutOff.sCourseName') 
                ->groupBy('tblCutOff.sCourseName');
    
            if (!empty($states)) {
                $query->whereIn('tblinstitutedetails.sState', $states); 
            }
    
            if (!empty($cities)) {
                $query->whereIn('tblinstitutedetails.sDistrict', $cities); 
            }

            if (!empty($programs)) {
                $query->whereIn('tblCutOff.sProgram', $programs); 
            }
    
            $result = $query->get();
    
            return response()->json([
                'success' => true,
                'data' => $result, 
                'message' => 'Programs retrieved successfully based on the filters.',
            ]);
        } catch (\Exception $e) {
            \Log::error('Error in getProgramsByFilter:', [
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString(), 
            ]);
    
            return response()->json([
                'success' => false,
                'message' => 'An error occurred while retrieving programs.',
            ], 500);
        }
    }



    // get branch by filter
    public function getBranchByCutOffFilter(Request $request)
    {
        try {
            // Validate the request
            $request->validate([
                'filter.selectedCities' => 'nullable|array',
                'filter.selectedCities.*' => 'string',
                'filter.selectedStates' => 'nullable|array',
                'filter.selectedStates.*' => 'string',
                'filter.selectedPrograms' => 'nullable|array',
                'filter.selectedPrograms.*' => 'string',
                'filter.selectCategory' => 'nullable|array',
                'filter.selectCategory.*' => 'string',
            ]);

            // Extract filters
            $cities = $request->input('filter.selectedCities', []);
            $states = $request->input('filter.selectedStates', []);
            $programs = $request->input('filter.selectedPrograms', []);
            $course = $request->input('filter.selectCategory', []);

            // Build the query
            $query = DB::table('tblCutOff')
                ->leftJoin('tblinstitutedetails', 'tblCutOff.iCollegeCode', '=', 'tblinstitutedetails.iCollegeCode')
                ->select('tblinstitutedetails.sBranchName', DB::raw('COUNT(DISTINCT tblCutOff.iCollegeCode) AS count'))
                ->where('tblCutOff.iBisActive', 1)
                ->whereNotNull('tblinstitutedetails.sBranchName')
                ->groupBy('tblinstitutedetails.sBranchName');

            // Apply filters
            if (!empty($states)) {
                $query->whereIn('tblinstitutedetails.sState', $states);
            }

            if (!empty($cities)) {
                $query->whereIn('tblinstitutedetails.sDistrict', $cities);
            }

            if (!empty($programs)) {
                $query->whereIn('tblCutOff.sProgram', $programs);
            }

            if (!empty($course)) {
                $query->whereIn('tblCutOff.sCourseName', $course);
            }

            // Execute query and fetch results
            $result = $query->get();

            // Return response
            return response()->json([
                'success' => true,
                'data' => $result,
                'total' => $result->count(),
                'message' => 'Programs retrieved successfully based on the filters.',
            ]);
        } catch (\Exception $e) {
            // Log error
            \Log::error('Error in getBranchByCutOffFilter:', [
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString(),
                'request_data' => $request->all(),
            ]);

            // Return error response
            return response()->json([
                'success' => false,
                'message' => 'An error occurred while retrieving programs.',
            ], 500);
        }
    }




     // get  status by filter
     public function getStatusByCutOffFilter(Request $request)
     {
         try {
           
             $request->validate([
                 'filter.selectedCities' => 'nullable|array',
                 'filter.selectedCities.*' => 'string', 
                 'filter.selectedStates' => 'nullable|array',
                 'filter.selectedStates.*' => 'string', 
                 'filter.selectedPrograms' => 'nullable|array',
                 'filter.selectedPrograms.*' => 'string', 
                 'filter.selectCategory' => 'nullable|array',
                 'filter.selectCategory.*' => 'string', 
             ]);
     
             // Extract filters from the request
             $cities = $request->input('filter.selectedCities', []);
             $states = $request->input('filter.selectedStates', []); 
             $programs = $request->input('filter.selectedPrograms', []); 
             $course = $request->input('filter.selectCategory', []); 
     
             $query = DB::table('tblCutOff')
                 ->leftJoin('tblinstitutedetails', 'tblCutOff.iCollegeCode', '=', 'tblinstitutedetails.iCollegeCode') 
                 ->select('tblinstitutedetails.sStatus', DB::raw('COUNT(tblCutOff.iCollegeCode) AS count')) 
                 ->where('tblCutOff.iBisActive', 1) 
                 ->whereNotNull('tblinstitutedetails.sStatus') 
                 ->groupBy('tblinstitutedetails.sStatus');
     
             if (!empty($states)) {
                 $query->whereIn('tblinstitutedetails.sState', $states); 
             }
     
             if (!empty($cities)) {
                 $query->whereIn('tblinstitutedetails.sDistrict', $cities); 
             }
 
             if (!empty($programs)) {
                 $query->whereIn('tblCutOff.sProgram', $programs); 
             }

             if (!empty($course)) {
                $query->whereIn('tblCutOff.sCourseName', $course); 
            }
     
             $result = $query->get();
     
             return response()->json([
                 'success' => true,
                 'data' => $result, 
                 'message' => 'Programs retrieved successfully based on the filters.',
             ]);
         } catch (\Exception $e) {
             \Log::error('Error in getProgramsByFilter:', [
                 'error' => $e->getMessage(),
                 'trace' => $e->getTraceAsString(), 
             ]);
     
             return response()->json([
                 'success' => false,
                 'message' => 'An error occurred while retrieving programs.',
             ], 500);
         }
     }
    
}

    
    



