<?php

namespace App\Http\Controllers\app;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;



class SlotBookingController extends Controller
{

    

    // Add  slot booking

    public function addSlotBooking(Request $request)
    {
        // Validate input fields: Make iStudentId and iSlotId required and others optional
        $request->validate([
            'iSlotId' => 'required|integer',
            'iStudentId' => 'required|integer',
            'sAddress' => 'nullable|string',  // Optional field
            'sProgram' => 'nullable|string',  // Optional field
            'sMobileNo' => 'nullable|string', // Optional field
            'sReason' => 'nullable|string',   // New optional reason field
        ]);
    
        // Retrieve the validated input data
        $data = $request->only(['iSlotId', 'iStudentId', 'sAddress', 'sProgram', 'sMobileNo', 'sReason']);
        
        // Add additional data for tracking
        $data['dtUpdatedDate'] = now();
        $data['iBisActive'] = 1;
    
        // Insert the data into the tblSlotBooking table and get the inserted ID
        $id = DB::table('tblSlotBooking')->insertGetId($data);
    
        // Return a successful response
        return response()->json(['result' => '2', 'message' => 'Slot added successfully', 'id' => $id], 201);
    }
    


    // Update slot Booking
    public function updateSlotBooking(Request $request)
    {
        try {
            // Retrieve the input data
            $data = $request->only([
                'iSlotId', 'iStudentId','sAddress', 'sProgram','sMobileNo', 'dtUpdatedDate'
            ]);
    
            // Retrieve the booking ID
            $iId = $request->input('iId');
            if (!$iId) {
                return response()->json(['message' => 'Booking ID is required'], 400);
            }
    
            // Set updated date
            $data['dtUpdatedDate'] = now();
    
            // Attempt to update the booking
            $updated = DB::table('tblSlotBooking')->where('iId', $iId)->update($data);
    
            if ($updated) {
                return response()->json(['result' => '3', 'message' => 'Slot updated successfully']);
            } else {
                Log::warning('Slot update failed', [
                    'iId' => $iId,
                    'data' => $data,
                ]);
                return response()->json(['message' => 'Slot failed to update'], 404);
            }
        } catch (\Exception $e) {
            // Log the error
            Log::error('An error occurred while updating the slot booking', [
                'error' => $e->getMessage(),
                'iId' => $request->input('iId'),
                'data' => $request->all(),
            ]);
    
            // Return a generic error response
            return response()->json(['message' => 'An unexpected error occurred'], 500);
        }
    }

    
    // Delete a record
    public function deleteSlotBooking($iId)
    {
        $deleted = DB::table('tblSlotBooking')->where('iId', $iId)->update(['iBisActive' => 0]);
        if ($deleted) {
            return response()->json(['result'=>'2','message' => 'Booked Slot deleted']);
        } else {
            return response()->json(['result'=>'2','message' => 'Booked Slot not found']);
        }
    }


    // get all slot Booking
    public function getAllSlotBooking()
    {
        $slotbooking=DB::table('tblSlotBooking')
        ->select('tblSlotBooking.*')
        ->where('tblSlotBooking.iBisActive', 1)
        ->get();
        return response()->json(['result'=>'1','data'=>$slotbooking]);
    }



    // get slotbooking by studentid
    public function getSlotBookingByStudentId($iId)
    {
        $institute = DB::table('tblSlotBooking')
        ->where([
            ['iStudentId', '=', $iId],          
            ['iBisActive', '=', 1],    
        ])
        ->first();
            
        if ($institute) {
            return response()->json([
                'result' => '1', 
                'message' => 'Slot Booked found successfully',
                'data' => $institute, 
            ]);
        } else {
            return response()->json([
                'result' => '5',
                'message' => 'Slot Booked not found',
            ], 404);
        }
    }

}
