<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Mail;
use App\Mail\SendPasswordMail1;
use App\Mail\PaymentLinkMail;
use Illuminate\Support\Facades\Http;



class PaymentController extends Controller
{
    /**
     * Add a new payment record.
     */

    // public function addPayment(Request $request)
    // {
    //     $validator = Validator::make($request->all(), [
    //         'iStudentId' => 'required|integer',
    //         'fPaybleAmount' => 'required|integer',
    //         'fPaidAmount' => 'required|integer',
    //         'sPaymentMode' => 'required|string|max:20',
    //         'dtUpdateddate' => 'nullable|date',
    //         'sOtherDetails1' => 'nullable|integer',
    //         'sOtherDetails2' => 'nullable|integer',
    //         'sOtherDetails3' => 'nullable|integer',
    //         'sOtherDetails4' => 'nullable|integer',
    //     ]);
    
    //     if ($validator->fails()) {
    //         return response()->json(['error' => $validator->errors()], 400);
    //     }
    
    //     try {
    //         DB::beginTransaction();
    
    //         // Fetch student
    //         $student = DB::table('tblregistration')
    //             ->where('iId', $request->iStudentId)
    //             ->first();
    
    //         if (!$student) {
    //             return response()->json(['message' => 'Student not found.', 'result' => '0'], 404);
    //         }
    
    //         // Decode counselling package JSON array
    //         $counsellingPackages = json_decode($student->iCounsellingPackageId, true);
    //         $firstPackage = $counsellingPackages[0] ?? null;
    
    //         if (!$firstPackage || empty($firstPackage['sProgram'])) {
    //             return response()->json(['result' => 6, 'message' => 'Program not found for student'], 422);
    //         }
    
    //         $programPrefixes = [
    //             'Medical' => 'ME',
    //             'Engineering' => 'EN',
    //             'Pharmacy' => 'PH',
    //             'Agriculture' => 'AG',
    //             'Architecture' => 'AR',
    //             'MBA' => 'MB',
    //             'MCA' => 'MC',
    //             'DSY Engineering' => 'DS',
    //         ];
    
    //         // Generate registration ID if not already present
    //         if (empty($student->iRegistrationId)) {
    //             $programName = $firstPackage['sProgram'];
    //             $prefix = $programPrefixes[$programName] ?? null;
    
    //             if (!$prefix) {
    //                 return response()->json(['result' => 6, 'message' => 'Invalid program for ID generation'], 422);
    //             }
    
    //             $yearPrefix = substr(date('Y'), -2);
    
    //             $lastStudent = DB::table('tblregistration')
    //                 ->where('iRegistrationId', 'LIKE', "{$prefix}{$yearPrefix}%")
    //                 ->orderBy('iRegistrationId', 'desc')
    //                 ->first();
    
    //             $lastNumber = $lastStudent
    //                 ? intval(substr($lastStudent->iRegistrationId, strlen($prefix) + 2))
    //                 : 0;
    
    //             $newStudentId = $prefix . $yearPrefix . str_pad($lastNumber + 1, 4, '0', STR_PAD_LEFT);
    
    //             DB::table('tblregistration')
    //                 ->where('iId', $student->iId)
    //                 ->update(['iRegistrationId' => $newStudentId]);
    
    //             $student->iRegistrationId = $newStudentId;
    //         }
    
    //         // Check for existing payment
    //         $existingPayment = DB::table('tblPayment')
    //             ->where('iStudentId', $request->iStudentId)
    //             ->first();
    
    //         $generatedPassword = null;
    
    //         if (!$existingPayment) {
    //             $generatedPassword = str_pad(random_int(100000, 999999), 6, '0', STR_PAD_LEFT);
    
    //             Log::info('Sending Email with:', [
    //                 'Username (Mobile)' => $student->sStudentMobileNo,
    //                 'Parent Mobile' => $student->sParentMobileNo,
    //                 'Password' => $generatedPassword
    //             ]);
    
    //             DB::table('tblregistration')
    //                 ->where('iId', $request->iStudentId)
    //                 ->update([
    //                     'sActiveStatus' => 'Active',
    //                     'sPassword' => bcrypt($generatedPassword),
    //                 ]);
    
    //             Mail::to($student->sEmailId)->send(new SendPasswordMail1(
    //                 $student->sEmailId,
    //                 $generatedPassword,
    //                 $student->sStudentMobileNo,
    //                 $student->sParentMobileNo
    //             ));
    //         }
    
    //         // Insert payment
    //         DB::table('tblPayment')->insert([
    //             'iStudentId' => $request->iStudentId,
    //             'fPaybleAmount' => $request->fPaybleAmount,
    //             'fPaidAmount' => $request->fPaidAmount,
    //             'sPaymentMode' => $request->sPaymentMode,
    //             'dtUpdateddate' => $request->dtUpdateddate ?? now(),
    //             'sOtherDetails1' => $request->sOtherDetails1,
    //             'sOtherDetails2' => $request->sOtherDetails2,
    //             'sOtherDetails3' => $request->sOtherDetails3,
    //             'sOtherDetails4' => $request->sOtherDetails4,
    //             'iBisActive' => 1,
    //         ]);
    
    //         DB::commit();
    
    //         return response()->json([
    //             'message' => 'Payment added successfully.',
    //             'result' => '1',
    //             'studentDetails' => [
    //                 'iStudentId' => $student->iId,
    //                 'iRegistrationId' => $student->iRegistrationId,
    //                 'sFirstName' => $student->sFirstName,
    //                 'sLastName' => $student->sLastName,
    //                 'sStudentMobileNo' => $student->sStudentMobileNo,
    //                 'sParentMobileNo' => $student->sParentMobileNo,
    //                 'password' => $generatedPassword,
    //             ],
    //         ]);
    
    //     } catch (\Exception $e) {
    //         DB::rollBack();
    
    //         Log::error('Error in addPayment:', [
    //             'error' => $e->getMessage(),
    //             'trace' => $e->getTraceAsString(),
    //         ]);
    
    //         return response()->json([
    //             'message' => 'An error occurred while processing the payment.',
    //             'error' => $e->getMessage(),
    //             'result' => '0',
    //         ], 500);
    //     }
    // }

// public function addPayment(Request $request)
// {
//     $validator = Validator::make($request->all(), [
//         'iStudentId' => 'required|integer',
//         'fPaybleAmount' => 'required|integer',
//         'fPaidAmount' => 'required|integer',
//         'sPaymentMode' => 'required|string|max:20',
//         'dtDate'=>'required|string',
//         'dtUpdateddate' => 'nullable|date',
//         'sOtherDetails1' => 'nullable|integer',
//         'sOtherDetails2' => 'nullable|integer',
//         'sOtherDetails3' => 'nullable|integer',
//         'sOtherDetails4' => 'nullable|integer',
//     ]);

//     if ($validator->fails()) {
//         return response()->json(['error' => $validator->errors()], 400);
//     }

//     try {
//         DB::beginTransaction();

//         // Fetch student
//         $student = DB::table('tblregistration')
//             ->where('iId', $request->iStudentId)
//             ->first();

//         if (!$student) {
//             return response()->json(['message' => 'Student not found.', 'result' => '0'], 404);
//         }

//         // Generate iRegistrationId if not already present
//         $counsellingPackages = json_decode($student->iCounsellingPackageId, true);
//         $firstPackage = $counsellingPackages[0] ?? null;

//         if (!$firstPackage || empty($firstPackage['sProgram'])) {
//             return response()->json(['result' => 6, 'message' => 'Program not found for student'], 422);
//         }

//         $programPrefixes = [
//             'Medical' => 'ME',
//             'Engineering' => 'EN',
//             'Pharmacy' => 'PH',
//             'Agriculture' => 'AG',
//             'Architecture' => 'AR',
//             'MBA' => 'MB',
//             'MCA' => 'MC',
//             'DSY Engineering' => 'DS',
//         ];

//         if (empty($student->iRegistrationId)) {
//             $programName = $firstPackage['sProgram'];
//             $prefix = $programPrefixes[$programName] ?? null;

//             if (!$prefix) {
//                 return response()->json(['result' => 6, 'message' => 'Invalid program for ID generation'], 422);
//             }

//             $yearPrefix = substr(date('Y'), -2);

//             $lastStudent = DB::table('tblregistration')
//                 ->where('iRegistrationId', 'LIKE', "{$prefix}{$yearPrefix}%")
//                 ->orderBy('iRegistrationId', 'desc')
//                 ->first();

//             $lastNumber = $lastStudent
//                 ? intval(substr($lastStudent->iRegistrationId, strlen($prefix) + 2))
//                 : 0;

//             $newStudentId = $prefix . $yearPrefix . str_pad($lastNumber + 1, 4, '0', STR_PAD_LEFT);

//             DB::table('tblregistration')
//                 ->where('iId', $student->iId)
//                 ->update(['iRegistrationId' => $newStudentId]);

//             $student->iRegistrationId = $newStudentId;
//         }

//         // Check for existing payment
//         $existingPayment = DB::table('tblPayment')
//             ->where('iStudentId', $request->iStudentId)
//             ->first();

//         $generatedPassword = null;

//         if (!$existingPayment) {
//             $generatedPassword = str_pad(random_int(100000, 999999), 6, '0', STR_PAD_LEFT);

//             Log::info('Sending Email with:', [
//                 'Username (Mobile)' => $student->sStudentMobileNo,
//                 'Parent Mobile' => $student->sParentMobileNo,
//                 'Password' => $generatedPassword
//             ]);

//             DB::table('tblregistration')
//                 ->where('iId', $request->iStudentId)
//                 ->update([
//                     'sActiveStatus' => 'Active',
//                     'sPassword' => bcrypt($generatedPassword),
//                 ]);

//             Mail::to($student->sEmailId)->send(new SendPasswordMail1(
//                 $student->sEmailId,
//                 $generatedPassword,
//                 $student->sStudentMobileNo,
//                 $student->sParentMobileNo
//             ));
            
//              // Send WhatsApp message using webhook.php
//             try {
//                  $whatsappResponse =Http::post('https://mysoftway.com/whatsapp/webhook.php', [
//     'to' => '91' . $student->sStudentMobileNo,
//     'name' => $student->sFirstName,
//     'StudentMobile' => $student->sStudentMobileNo,
//     'ParentMobile' => $student->sParentMobileNo,
//     'password' => $generatedPassword
// ]);



        
//                 Log::info('WhatsApp message sent:', [
//                     'status' => $whatsappResponse->status(),
//                     'response' => $whatsappResponse->body()
//                 ]);
//             } catch (\Exception $e) {
//                 Log::error('Failed to send WhatsApp message: ' . $e->getMessage());
//             }
//         }

//         // Insert payment
//         DB::table('tblPayment')->insert([
//             'iStudentId' => $request->iStudentId,
//             'fPaybleAmount' => $request->fPaybleAmount,
//             'fPaidAmount' => $request->fPaidAmount,
//             'sPaymentMode' => $request->sPaymentMode,
//             'dtDate'=>$request->dtDate,
//             'dtUpdateddate' => $request->dtUpdateddate ?? now(),
//             'sOtherDetails1' => $request->sOtherDetails1,
//             'sOtherDetails2' => $request->sOtherDetails2,
//             'sOtherDetails3' => $request->sOtherDetails3,
//             'sOtherDetails4' => $request->sOtherDetails4,
//             'iBisActive' => 1,
//         ]);

//         // ðŸ”— Generate payment receipt link
//         $receiptUrl =  route('payment.process', ['id' => $student->iId]);

//         // ðŸ“§ Email the receipt
//         Mail::to($student->sEmailId)->send(new PaymentLinkMail($receiptUrl));
//         Mail::to('bhagaje25@gmail.com')->send(new PaymentLinkMail($receiptUrl));
//       Mail::to('varshaalate86@gmail.com')->send(new PaymentLinkMail($receiptUrl));
//         // âœ… OPTIONAL: Send WhatsApp receipt link
//         // app(WhatsappController::class)->sendPaymentReceipt($student->sStudentMobileNo, $receiptUrl);

//         DB::commit();

//         return response()->json([
//             'message' => 'Payment added successfully.',
//             'result' => '1',
//             'studentDetails' => [
//                 'iStudentId' => $student->iId,
//                 'iRegistrationId' => $student->iRegistrationId,
//                 'sFirstName' => $student->sFirstName,
//                 'sLastName' => $student->sLastName,
//                 'sStudentMobileNo' => $student->sStudentMobileNo,
//                 'sParentMobileNo' => $student->sParentMobileNo,
//                 'password' => $generatedPassword,
//             ],
//         ]);

//     } catch (\Exception $e) {
//         DB::rollBack();

//         Log::error('Error in addPayment:', [
//             'error' => $e->getMessage(),
//             'trace' => $e->getTraceAsString(),
//         ]);

//         return response()->json([
//             'message' => 'An error occurred while processing the payment.',
//             'error' => $e->getMessage(),
//             'result' => '0',
//         ], 500);
//     }
// }
public function addPayment(Request $request)
{
    $validator = Validator::make($request->all(), [
        'iStudentId' => 'required|integer',
        'fPaybleAmount' => 'required|integer',
        'fPaidAmount' => 'required|integer',
        'sPaymentMode' => 'required|string|max:20',
        'dtDate' => 'required|string',
        'dtUpdateddate' => 'nullable|date',
        'sOtherDetails1' => 'nullable|integer',
        'sOtherDetails2' => 'nullable|integer',
        'sOtherDetails3' => 'nullable|integer',
        'sOtherDetails4' => 'nullable|integer',
    ]);

    if ($validator->fails()) {
        return response()->json(['error' => $validator->errors()], 400);
    }

    try {
        DB::beginTransaction();

        $student = DB::table('tblregistration')->where('iId', $request->iStudentId)->first();

        if (!$student) {
            return response()->json(['message' => 'Student not found.', 'result' => '0'], 404);
        }

        $counsellingPackages = json_decode($student->iCounsellingPackageId, true);
        $firstPackage = $counsellingPackages[0] ?? null;

        if (!$firstPackage || empty($firstPackage['sProgram'])) {
            return response()->json(['result' => 6, 'message' => 'Program not found for student'], 422);
        }

        $programPrefixes = [
            'Medical' => 'ME',
            'Engineering' => 'EN',
            'Pharmacy' => 'PH',
            'Agriculture' => 'AG',
            'Architecture' => 'AR',
            'MBA' => 'MB',
            'MCA' => 'MC',
            'DSY Engineering' => 'DS',
        ];

        if (empty($student->iRegistrationId)) {
            $programName = $firstPackage['sProgram'];
            $prefix = $programPrefixes[$programName] ?? null;

            if (!$prefix) {
                return response()->json(['result' => 6, 'message' => 'Invalid program for ID generation'], 422);
            }

            $yearPrefix = substr(date('Y'), -2);
            $lastStudent = DB::table('tblregistration')
                ->where('iRegistrationId', 'LIKE', "{$prefix}{$yearPrefix}%")
                ->orderBy('iRegistrationId', 'desc')
                ->first();

            $lastNumber = $lastStudent ? intval(substr($lastStudent->iRegistrationId, strlen($prefix) + 2)) : 0;
            $newStudentId = $prefix . $yearPrefix . str_pad($lastNumber + 1, 4, '0', STR_PAD_LEFT);

            DB::table('tblregistration')->where('iId', $student->iId)->update([
                'iRegistrationId' => $newStudentId
            ]);

            $student->iRegistrationId = $newStudentId;
        }

        $existingPayment = DB::table('tblPayment')->where('iStudentId', $request->iStudentId)->first();

        $generatedPassword = null;

        if (!$existingPayment) {
            $generatedPassword = str_pad(random_int(100000, 999999), 6, '0', STR_PAD_LEFT);

            DB::table('tblregistration')->where('iId', $request->iStudentId)->update([
                'sActiveStatus' => 'Active',
                'sPassword' => bcrypt($generatedPassword),
            ]);

            // Mail::to($student->sEmailId)->send(new SendPasswordMail1(
            //     $student->sEmailId,
            //     $generatedPassword,
            //     $student->sStudentMobileNo,
            //     $student->sParentMobileNo
            // ));

            // Send WhatsApp message with password
            // try {
            //   $whatsappResponse = Http::post('https://mysoftway.com/whatsapp/webhook.php', [
            //         'template' => 'account_creation_confirmation',
            //         'to' => '91' . $student->sStudentMobileNo,
            //         'name' => $student->sFirstName,
            //         'StudentMobile' => $student->sStudentMobileNo,
            //         'ParentMobile' => $student->sParentMobileNo,
            //         'password' => $generatedPassword,
            //         'registrationId' => $student->iRegistrationId // Include the generated registration ID
            //     ]);


            //     Log::info('Password WhatsApp message sent:', [
            //         'status' => $whatsappResponse->status(),
            //         'response' => $whatsappResponse->body()
            //     ]);
            // } catch (\Exception $e) {
            //     Log::error('Failed to send password WhatsApp message: ' . $e->getMessage());
            // }
        }

        DB::table('tblPayment')->insert([
            'iStudentId' => $request->iStudentId,
            'fPaybleAmount' => $request->fPaybleAmount,
            'fPaidAmount' => $request->fPaidAmount,
            'sPaymentMode' => $request->sPaymentMode,
            'dtDate' => $request->dtDate,
            'dtUpdateddate' => $request->dtUpdateddate ?? now(),
            'sOtherDetails1' => $request->sOtherDetails1,
            'sOtherDetails2' => $request->sOtherDetails2,
            'sOtherDetails3' => $request->sOtherDetails3,
            'sOtherDetails4' => $request->sOtherDetails4,
            'iBisActive' => 1,
        ]);

        $receiptUrl = route('payment.process', ['id' => $student->iId]);

        // Mail::to($student->sEmailId)->send(new PaymentLinkMail($receiptUrl));
        // Mail::to('bhagaje25@gmail.com')->send(new PaymentLinkMail($receiptUrl));
        // Mail::to('varshaalate86@gmail.com')->send(new PaymentLinkMail($receiptUrl));

        // Send WhatsApp receipt message
        // try {
        //     $receiptWhatsappResponse = Http::post('https://mysoftway.com/whatsapp/webhook.php', [
        //         'template' => 'a2zadmission_receipt',
        //         'to' => '91' . $student->sStudentMobileNo,
        //         'name' => $student->sFirstName,
        //         'link' => $receiptUrl
        //     ]);

        //     Log::info('Receipt WhatsApp message sent:', [
        //         'status' => $receiptWhatsappResponse->status(),
        //         'response' => $receiptWhatsappResponse->body()
        //     ]);
        // } catch (\Exception $e) {
        //     Log::error('Failed to send receipt WhatsApp message: ' . $e->getMessage());
        // }

        DB::commit();

        return response()->json([
            'message' => 'Payment added successfully.',
            'result' => '1',
            'studentDetails' => [
                'iStudentId' => $student->iId,
                'iRegistrationId' => $student->iRegistrationId,
                'sFirstName' => $student->sFirstName,
                'sLastName' => $student->sLastName,
                'sStudentMobileNo' => $student->sStudentMobileNo,
                'sParentMobileNo' => $student->sParentMobileNo,
                'password' => $generatedPassword,
            ],
        ]);

    } catch (\Exception $e) {
        DB::rollBack();

        Log::error('Error in addPayment:', [
            'error' => $e->getMessage(),
            'trace' => $e->getTraceAsString(),
        ]);

        return response()->json([
            'message' => 'An error occurred while processing the payment.',
            'error' => $e->getMessage(),
            'result' => '0',
        ], 500);
    }
}



public function process($id)
{
    // Join tblPayment with tblRegistration
    $payment = DB::table('tblPayment as p')
        ->join('tblregistration as r', 'p.iStudentId', '=', 'r.iId')
        ->where('p.iStudentId', $id)
        ->select(
            'p.*',
            'r.sFirstName',
            'r.iRegistrationId',
            'r.sStudentMobileNo',
            'r.iCounsellingPackageId',
            'r.sEmailId'
        )
        ->first();

    if (!$payment) {
        return redirect()->back()->with('error', 'Payment record not found.');
    }

    // Decode iCounsellingPackageId JSON
    $packageData = json_decode($payment->iCounsellingPackageId, true);

    // Extract sProgram (safely handle if array is empty or malformed)
    $sProgram = isset($packageData[0]['sProgram']) ? $packageData[0]['sProgram'] : 'N/A';

    // Ensure the fPayableAmount exists and is accessible, otherwise fall back to a default value
    $totalPayableAmount = isset($payment->fPayableAmount) ? $payment->fPayableAmount : 0;

    // Option 2: Sum of paid amounts (if needed)
    $paidAmount = DB::table('tblPayment')
                    ->where('iStudentId', $id)
                    ->sum('fPaidAmount'); // Summing paid amounts for the student

    // Final total amount (either fPayableAmount or sum of paid amounts)
    $finalAmount = $paidAmount; // Calculating balance amount or can be a separate logic

    return view('payment.process', compact('payment', 'sProgram', 'finalAmount'));
}




    /**
     * Get active payment details for a specific student.
     */
    public function getPaymentDetails($studentId)
    {
        $payments = DB::table('tblPayment')
            ->where('iStudentId', $studentId)
            ->where('iBisActive', 1)  // Only active payments
            ->get();

        if ($payments->isEmpty()) {
            return response()->json(['message' => 'No active payments found for this student.']);
        }

        return response()->json($payments);
    }



    /**
     * Update payment details by payment ID.
     */
   public function updatePayment(Request $request)
    {
    $validator = Validator::make($request->all(), [
        'iId' => 'required|integer',
        'fPaybleAmount' => 'nullable|integer',
        'fPaidAmount' => 'nullable|integer',
        'sPaymentMode' => 'nullable|string|max:20',
        'dtDate' => 'nullable|string',
        'dtUpdateddate' => 'nullable|date',
        'sOtherDetails1' => 'nullable|integer',
        'sOtherDetails2' => 'nullable|integer',
        'sOtherDetails3' => 'nullable|integer',
        'sOtherDetails4' => 'nullable|integer',
    ]);

    if ($validator->fails()) {
        return response()->json(['error' => $validator->errors()], 400);
    }

    $paymentId = $request->iId;

    $payment = DB::table('tblPayment')->where('iId', $paymentId)->where('iBisActive', 1)->first();

    if (!$payment) {
        return response()->json(['message' => 'Payment not found or already deleted.'], 404);
    }

    $data = $request->only([
        'fPaybleAmount',
        'fPaidAmount',
        'sPaymentMode',
        'dtDate',
        'dtUpdateddate',
        'sOtherDetails1',
        'sOtherDetails2',
        'sOtherDetails3',
        'sOtherDetails4'
    ]);

    DB::table('tblPayment')->where('iId', $paymentId)->update($data);

    return response()->json(['message' => 'Payment details updated successfully.']);
}



    /**
     * Soft delete a payment by setting iBisActive to 0.
     */
    public function deletePayment($paymentId)
    {
        $payment = DB::table('tblPayment')->where('iId', $paymentId)->where('iBisActive', 1)->first();

        if (!$payment) {
            return response()->json(['message' => 'Payment not found or already deleted.'], 404);
        }

        DB::table('tblPayment')->where('iId', $paymentId)->update(['iBisActive' => 0]);

        return response()->json(['result'=>'4','message' => 'Payment deleted successfully (soft delete).']);
    }
    
    
    
    //get payment buy date    
   public function getPaymentByDatePayment(Request $request)
   {
    // Validate date input
    $validator = Validator::make($request->all(), [
        'date' => 'required|date_format:Y-m-d', // Ensure valid date format
    ]);

    if ($validator->fails()) {
        return response()->json(['error' => $validator->errors()], 400);
    }

    $date = $request->input('date');

    try {
        // Fetch registrations and payments for the given payment date
        $registrations = DB::table('tblregistration as r')
            ->leftJoin('tblPayment as p', 'r.iId', '=', 'p.iStudentid')
            ->select(
                'r.sFirstName','r.sLastName',
                'p.*', // Select everything from tblPayment
                'r.dtUpdatedDate as registration_dtUpdatedDate', // Alias for registration date
                'p.dtDate as payment_dtUpdatedDate' // Alias for payment date
            )
            ->whereDate('p.dtDate', $date) // Filter by the payment date only
            ->where('r.iBisActive', 1)  // Only active students
            ->get();

        if ($registrations->isEmpty()) {
            return response()->json([
                'result' => '6',
                'message' => 'No active registrations found for the selected date',
            ], 404);
        }

        // Return response
        return response()->json([
            'result' => '1',
            'message' => 'Registrations and payment details retrieved successfully',
            'data' => $registrations,
        ], 200);
    } catch (\Exception $e) {
        // Handle errors and log the exception
        Log::error('Error in getRegistrationsByDate API:', [
            'error' => $e->getMessage(),
            'trace' => $e->getTraceAsString(),
        ]);

        return response()->json([
            'result' => '0',
            'message' => 'An error occurred while fetching the data',
            'error' => $e->getMessage(),
        ], 500);
    }
}



    public function PaymentSummary(Request $request)
    {
        $request->validate([
            'sStudentId' => 'required|integer',
        ]);
    
        $sStudentId = $request->sStudentId;
    
        $payments = DB::table('tblPayment')
            ->where('iStudentId', $sStudentId)
            ->where('iBisActive', 1);
    
        $totalPaidAmount = $payments->sum('fPaidAmount');
        $latestPayableAmount = $payments->orderByDesc('dtUpdateddate')->value('fPaybleAmount');
    
        return response()->json([
            'sStudentId' => $sStudentId,
            'fTotalPaidAmount' => $totalPaidAmount,
            'fPaybleAmount' => $latestPayableAmount,
            'fRemainingAmount' => $latestPayableAmount - $totalPaidAmount,
        ]);
    }


}
