<?php
namespace App\Http\Controllers\App;
use Illuminate\Support\Facades\Schema;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;

class StudentCategotyController extends Controller
{
    
    // Add new Social Category (Create)
    public function addCategoryOfStudents(Request $request)
    {
        // Validate input
        $request->validate([
            'iStudentId' => 'required|numeric',
            'sCategory' => 'required|string',
            'sSpecialCategory' => 'nullable|string',
            'sOtherCategory' => 'nullable|string',
            'sMinorityStatus' => 'nullable|string',
            'sMinorityDetails' => 'nullable|string',
            'sAnnualIncome' => 'nullable|string',
            'sFathersOccupation' => 'nullable|string',
            'sMothersOccupation' => 'nullable|string',
            'sDisabilty' => 'nullable|string',
            'sDisabilityStatus'=>'nullable|string',
            'iBisActive' => 'nullable|boolean',
            'sOtherDetails1' => 'nullable|string',
            'sOtherDetails2' => 'nullable|string',
            'sOtherDetails3' => 'nullable|string',
            'sOtherDetails4' => 'nullable|string',
            'sOtherDetails5' => 'nullable|string',
        ]);
       //  dd($request->all()); // Check what data is actually being received
       //  dd($data);

        // Prepare data
        $data = $request->only([
            'iStudentId', 'sCategory', 'sSpecialCategory','	sOtherCategory', 'sMinorityStatus', 'sMinorityDetails','sAnnualIncome','sMothersOccupation','sDisabilty','sDisabilityStatus','sFathersOccupation','iBisActive', 
            'sOtherDetails1', 'sOtherDetails2', 'sOtherDetails3', 'sOtherDetails4','sOtherDetails5'
        ]);
        $data['dtUpdatedDate'] = now();
        // Insert student data into the database using DB::table()
        $studentId = DB::table('tblSocialCategoryOfStudents')->insertGetId($data);

        // Return success response
        return response()->json([
            'message' => 'Student added successfully',
            'result' =>"2",
            'data' => ['iId' => $studentId] // Returning the inserted student ID
        ], 201);
    }


 
    // Get Social Category of student by ID (Read)
    public function getCategoryOfStudentsById($id)
    {
        // Find student by ID using DB::table() 
        $student = DB::table('tblSocialCategoryOfStudents')
            ->where('iId', $id)
            ->first();  // Using first() to get a single result

        if (!$student) {
            // Return error if student not found
            return response()->json([
                'message' => 'Student Qualification not found',
                'result' => '5'
            ]);
        }
        $studentArray = (array) $student;
        // Return student data
        return response()->json([
            'data' => [$studentArray], // Wrapping in an array
            'result' => '1'
        ]);   
        
    }




    // get all
    public function getAllCategoryOfStudents()
    {

        $profile = DB::table('tblSocialCategoryOfStudents')->where('iBisActive' , 1)->get();


        return response()->json(['data'=>$profile,'result'=>'1']);
    }




    // Update Socail Category of Students (Update)
    public function updateCategoryOfStudents(Request $request)
    {
        // Validate input
        $request->validate([
            'iStudentId' => 'required|numeric',
            'sCategory' => 'required|string',
            'sSpecialCategory' => 'nullable|string',
            'sOtherCategory' => 'nullable|string',
            'sMinorityStatus' => 'nullable|string',
            'sMinorityDetails' => 'nullable|string',
            'sAnnualIncome' => 'nullable|string',
            'sFathersOccupation' => 'nullable|string',
            'sMothersOccupation' => 'nullable|string',
            'sDisabilty' => 'nullable|string',
            'sDisabilityStatus'=>'nullable|string',
            'iBisActive' => 'nullable|boolean',
            'sOtherDetails1' => 'nullable|string',
            'sOtherDetails2' => 'nullable|string',
            'sOtherDetails3' => 'nullable|string',
            'sOtherDetails4' => 'nullable|string',
            'sOtherDetails5' => 'nullable|string',
        ]);
        $id =  $request->input('iId');

        // Find student by ID using DB::table()
        $student = DB::table('tblSocialCategoryOfStudents')
            ->where('iId', $id)
            ->first();  // Check if student exists

        if (!$student) {
            // Return error if student not found
            return response()->json([
                'message' => 'Student not found',
                'result' => '5'
            ]);
        }

        // Prepare data for update
        $data = $request->only([
            'iStudentId', 'sCategory', 'sSpecialCategory','	sOtherCategory', 'sMinorityStatus', 'sMinorityDetails','sAnnualIncome','sMothersOccupation','sDisabilty','sDisabilityStatus','sFathersOccupation','iBisActive', 
            'sOtherDetails1', 'sOtherDetails2', 'sOtherDetails3', 'sOtherDetails4','sOtherDetails5'
        ]);
        $data['dtUpdatedDate'] = now();

        // Update student data in the database using DB::table()
        DB::table('tblSocialCategoryOfStudents')
            ->where('iId', $id)
            ->update($data);  // Use update() method to update student data

        // Return success response
        return response()->json([
            'message' => 'Student updated successfully',
            'data' => $data,
            'result'=>'3'
        ]);
    }



  



    // Delete Social Caegory of student profile (Delete)
    public function deleteCategoryOfStudents($id)
    {
        // Find student by ID using DB::table()
        $student = DB::table('tblSocialCategoryOfStudents')
            ->where('iId', $id)
            ->first();  // Check if student exists

        if (!$student) {
            // Return error if student not found
            return response()->json([
                'message' => 'Student Qualification not found',
                'result' => '5'
            ]);
        }

        // Delete student profile from the database using DB::table()
        DB::table('tblSocialCategoryOfStudents')
            ->where('iId', $id)
            ->delete();  // Use delete() to remove the record

        // Return success response
        return response()->json([
            'message' => 'Student Qualification deleted successfully'
        ]);
    }

    

   // Get Cocial Category of student by ID (Read)
   public function getCategoryByStudentId($id)
   {
       $student = DB::table('tblSocialCategoryOfStudents')
           ->where('iStudentId', $id)
           ->where('iBisActive',1)
           ->first();  

       if (!$student) {
           return response()->json([
               'message' => 'Student Qualification not found'
           ], 404);
       }

       $studentArray = (array) $student;
       // Return student data
       return response()->json([
           'data' => [$studentArray], // Wrapping in an array
           'result' => '1'
       ]);  
   }
}
