<?php

// app/Http/Controllers/Admin/EmailController.php

namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;

class EmailController extends Controller
{
    public function sendEmail(Request $request)
    {
        // Validate the incoming request data
        $request->validate([
            'email' => 'required|email',
            'subject' => 'required|string',
            'message' => 'required|string'
        ]);

        // Send the email directly without using a Blade template
        Mail::raw($request->message, function ($message) use ($request) {
            $message->to($request->email)
                    ->subject($request->subject);
        });

        // Return a response to indicate success
        return response()->json(['message' => 'Email sent successfully']);
    }
}
