<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class PaymentLinkMail extends Mailable
{
    use Queueable, SerializesModels;

    public $paymentUrl;

    public function __construct($paymentUrl)
    {
        $this->paymentUrl = $paymentUrl;
    }

    public function build()
    {
        // Pass paymentUrl to the view for rendering
        return $this->subject('Your Payment Link')
                    ->view('emails.payment_link')
                    ->with([
                        'paymentUrl' => $this->paymentUrl, // Pass the payment URL here
                    ]);
    }
}
