<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class SlotBookingConfirmationMail extends Mailable
{
    use Queueable, SerializesModels;

    public $bookingDetails;

    public function __construct($bookingDetails)
    {
        $this->bookingDetails = $bookingDetails;
    }

    public function build()
    {
        return $this->subject('Slot Booking Confirmation')
                    ->markdown('emails.slot_booking')
                    ->with('bookingDetails', $this->bookingDetails);
    }
}
