<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;


class programStepController extends Controller
{

    // Add program steps
    public function addProgramStep(Request $request)
    {
         // Extract required fields from the request
         $data = $request->only([
             'sProgram', 'sTitle', 'sDescription', 'dtDateFrom', 'dtDateTo', 'iStepNo', 'iYear', 'iBisActive', 'dtUpdatedDate'
         ]);
     
         // Set default values
         $data['dtUpdatedDate'] = now();
         $data['iBisActive'] = 1;
     
         // Process 'sDocuments'
         $documents = $request->input('sDocuments');
         if (is_array($documents)) {
             $data['sDocuments'] = json_encode($documents);
         } else {
             return response()->json(['result' => '0', 'message' => 'Invalid format for sDocuments. Must be an array.'], 400);
         }
     
         $id = DB::table('tblAdmissionSteps')->insertGetId($data);
     
         return response()->json(['result' => '2', 'message' => 'Step Added Successfully', 'id' => $id], 201);
    }
     


    // get steps
    public function getAllProgramSteps()
    {
        $steps = DB::table('tblAdmissionSteps')->where('iBisActive', 1)->get();

        if ($steps->isEmpty()) {
            return response()->json(['result' => '0', 'message' => 'No steps found'], 404);
        }

        foreach ($steps as $step) {
            $step->sDocuments = $step->sDocuments ? json_decode($step->sDocuments, true) : null;
        }

        return response()->json(['result' => '1', 'message' => 'Steps retrieved successfully', 'data' => $steps], 200);
    }



    // Get steps by program and year
    public function getStepsByProgramAndYear(Request $request)
    {
        $data = $request->json()->all();
        
        $sProgram = $data['filter']['program'] ?? null;
        $iYear = $data['filter']['year'] ?? null;
        
        if (!$sProgram) {
            return response()->json(['result' => '0', 'message' => 'Program is required'], 400);
        }
        
        $query = DB::table('tblAdmissionSteps')->where('sProgram', $sProgram);
        
        if ($iYear) {
            $query->where('iYear', $iYear);
        }
        
        $steps = $query->get();
        
        if ($steps->isEmpty()) {
            // Respond with result=0 and HTTP 200 to indicate no data
            return response()->json(['result' => '0', 'message' => 'No steps found for the given Program and Year', 'data' => []], 200);
        }
        
        foreach ($steps as $step) {
            $step->sDocuments = $step->sDocuments ? json_decode($step->sDocuments, true) : null;
        }
        
        return response()->json(['result' => '1', 'message' => 'Steps retrieved successfully', 'data' => $steps], 200);
    }
    


    // update the program steps
    public function updateProgramStep(Request $request)
    {
        $data = $request->only([
            'sProgram', 'sTitle', 'sDescription', 'dtDateFrom', 'dtDateTo', 
            'iStepNo', 'iYear', 'iBisActive', 'sOtherDetails1', 
            'sOtherDetails2', 'sOtherDetails3', 'sOtherDetails4'
        ]);
    
        $data['dtUpdatedDate'] = now();
        $iId = $request->input('iId'); 
    
        // Handle sDocuments
        $documents = $request->input('sDocuments'); 
        if (is_array($documents)) {
            $data['sDocuments'] = json_encode($documents);
        } else {
            $data['sDocuments'] = $documents; 
        }
    
        // Check if the record exists
        $recordExists = DB::table('tblAdmissionSteps')->where('iId', $iId)->exists();
    
        if (!$recordExists) {
            return response()->json(['result' => '4', 'message' => 'Record Not Found'], 404);
        }
    
        // Perform the update
        $updated = DB::table('tblAdmissionSteps')
            ->where('iId', $iId)
            ->update($data);
    
        // Handle update response
        if ($updated) {
            return response()->json(['result' => '3', 'message' => 'Step Updated Successfully'], 200);
        } else {
            return response()->json(['result' => '6', 'message' => 'No Changes Detected'], 200); // Return success with no changes
        }
    }
    

    // delete admission steps
    public function deleteAdmissionStep($iId)
    {
             // Find the registration by ID
             $steps = DB::table('tblAdmissionSteps')->where('iId', $iId)->first();
 
             if (!$steps) {
                 return response()->json(['result' => 0, 'message' => 'Registration not found'], 404);
             }
 
             $updated = DB::table('tblAdmissionSteps')->where('iId', $iId)->update(['iBisActive' => 0]);
 
             if ($updated) {
                 return response()->json(['result' => "4", 'message' => 'Program Steps Deleted'], 200);
             } else {
                 return response()->json(['result' => "5", 'message' => 'Failed to delete program step'], 500);
             }
    }

    
     
}
