<?php

namespace App\Http\Controllers\app;

use Illuminate\Support\Facades\Schema;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;

class StudentQualificationController extends Controller
{
     // Add new Qualification (Create)
     public function addQualificationOfStudents(Request $request)
     {
         // Validate input
         $request->validate([
             'iStudentId' => 'required|numeric',
             's10thPassStatus' => 'required|string',
             's10thYearPassing' => 'nullable|string',
             's10ThPalceOfSchool' => 'nullable|string',
             's10thSchoolType' => 'nullable|string',
             's10thQualifyingState' => 'nullable|string',
             's10thBoard' => 'nullable|string',
             's10thResultMode' => 'nullable|string',
             'f10thMarks' => 'nullable|numeric',
             'i10thTotalMarks' => 'nullable|integer',
             'i10thObtainedMarks'=>'nullable|integer',
             's10thRollNo'=>'nullable|string',
             's10thSchoolName'=>'nullable|string',
             's10thSchoolAddress'=>'nullable|string',
             's10thSchoolPinCode'=>'nullable|string',
             's12thPassStatus' => 'nullable|string',
             's12thYearPassing' => 'nullable|string',
             'S12ThPalceOfSchool' => 'nullable|string',
             's12thSchoolType' => 'nullable|string',
             's12thQualifyingState' => 'nullable|string',
             's12thBoard' => 'nullable|string',
             's12thResultMode' => 'nullable|string',
             'f12thMarks' => 'nullable|numeric',
             'i12thTotalMarks' => 'nullable|integer',
             'i12thObtainedMarks'=>'nullable|integer',
             's12thRollNo'=>'nullable|string',
             's12thSchoolName'=>'nullable|string',
             's12thSchoolAddress'=>'nullable|string',
             's12thSchoolPinCode'=>'nullable|string',
             'sNameOfEntranceExam'=>'nullable|string',
             'sMonthOfPassing'=>'nullable|string',
             'fMarksObtained'=>'nullable|numeric',
             'fPercentileObtained'=>'nullable|numeric',
             'sAIR'=>'nullable|string',
             'sCategoryRank'=>'nullable|string',
             'iBisActive' => 'nullable|boolean',
             'sOtherDetails1' => 'nullable|string',
             'sOtherDetails2' => 'nullable|string',
             'sOtherDetails3' => 'nullable|string',
             'sOtherDetails4' => 'nullable|string',
             'sOtherDetails5' => 'nullable|string',
         ]);
        //  dd($request->all()); // Check what data is actually being received
        //  dd($data);

         // Prepare data
         $data = $request->only([
             'iStudentId', 's10thPassStatus', 's10thYearPassing','s10ThPalceOfSchool', 's10thSchoolType', 's10thQualifyingState','s10thBoard','s10thResultMode','f10thMarks','i10thTotalMarks','i10thObtainedMarks','s10thRollNo','s10thSchoolName','s10thSchoolAddress','s10thSchoolPinCode','s12thPassStatus','s12thYearPassing','S12ThPalceOfSchool','s12thSchoolType','s12thQualifyingState','s12thBoard','s12thResultMode','f12thMarks','i12thTotalMarks','i12thObtainedMarks','s12thRollNo','s12thSchoolName','s12thSchoolAddress','s12thSchoolPinCode','sNameOfEntranceExam','sMonthOfPassing','	fMarksObtained','	fPercentileObtained','sAIR','sCategoryRank','iBisActive', 
             'sOtherDetails1', 'sOtherDetails2', 'sOtherDetails3', 'sOtherDetails4','sOtherDetails5'
         ]);
         $data['dtUpdatedDate'] = now();
         // Insert student data into the database using DB::table()
         $studentId = DB::table('tblQualificationOfStudents')->insertGetId($data);
 
         // Return success response
         return response()->json([
             'message' => 'Student added successfully',
             'result' => "1",
             'data' => ['iId' => $studentId] // Returning the inserted student ID
         ], 201);
     }
 
 
  
     // Get Qualification of student by ID (Read)
     public function getQualification($id)
     {
         // Find student by ID using DB::table() 
         $student = DB::table('tblQualificationOfStudents')
             ->where('iId', $id)
             ->first();  // Using first() to get a single result
 
         if (!$student) {
             // Return error if student not found
             return response()->json([
                 'message' => 'Student Qualification not found'
             ], 404);
         }
 
         // Return student data
         return response()->json(['data' => $student , 'result'=>"1"]);
     }
 
 


     // get all
     public function getAllQualificationOfStudents()
     {
 
         $profile = DB::table('tblQualificationOfStudents')->where('iBisActive' , 1)->get();
 
 
         return response()->json($profile);
     }
 
 
 
 
     // Update student profile (Update)
     public function updateQualificationOfStudents(Request $request)
     {
         // Validate input
         $request->validate([
            'iStudentId' => 'required|numeric',
            's10thPassStatus' => 'required|string',
            's10thYearPassing' => 'nullable|string',
            's10ThPalceOfSchool' => 'nullable|string',
            's10thSchoolType' => 'nullable|string',
            's10thQualifyingState' => 'nullable|string',
            's10thBoard' => 'nullable|string',
            's10thResultMode' => 'nullable|string',
            'f10thMarks' => 'nullable|numeric',
            'i10thTotalMarks' => 'nullable|integer',
            'i10thObtainedMarks'=>'nullable|integer',
            's10thRollNo'=>'nullable|string',
            's10thSchoolName'=>'nullable|string',
            's10thSchoolAddress'=>'nullable|string',
            's10thSchoolPinCode'=>'nullable|string',
            's12thPassStatus' => 'required|string',
            's12thYearPassing' => 'required|string',
            'S12ThPalceOfSchool' => 'nullable|string',
            's12thSchoolType' => 'nullable|string',
            's12thQualifyingState' => 'nullable|string',
            's12thBoard' => 'nullable|string',
            's12thResultMode' => 'nullable|string',
            'f12thMarks' => 'nullable|numeric',
            'i12thTotalMarks' => 'nullable|integer',
            'i12thObtainedMarks'=>'nullable|integer',
            's12thRollNo'=>'nullable|string',
            's12thSchoolName'=>'nullable|string',
            's12thSchoolAddress'=>'nullable|string',
            's12thSchoolPinCode'=>'nullable|string',
            'sNameOfEntranceExam'=>'nullable|string',
            'sMonthOfPassing'=>'nullable|string',
            'fMarksObtained'=>'nullable|numeric',
            'fPercentileObtained'=>'nullable|numeric',
            'sAIR'=>'nullable|string',
            'sCategoryRank'=>'nullable|string',
            'iBisActive' => 'nullable|boolean',
            'sOtherDetails1' => 'nullable|string',
            'sOtherDetails2' => 'nullable|string',
            'sOtherDetails3' => 'nullable|string',
            'sOtherDetails4' => 'nullable|string',
            'sOtherDetails5' => 'nullable|string',
        ]);
         $id =  $request->input('iId');
 
         // Find student by ID using DB::table()
         $student = DB::table('tblQualificationOfStudents')
             ->where('iId', $id)
             ->first();  // Check if student exists
 
         if (!$student) {
             // Return error if student not found
             return response()->json([
                 'message' => 'Student not found'
             ], 404);
         }
 
         // Prepare data for update
         $data = $request->only([
            'iStudentId', 's10thPassStatus', 's10thYearPassing	','s10ThPalceOfSchool', 's10thSchoolType', 's10thQualifyingState','s10thBoard','s10thResultMode','f10thMarks','i10thTotalMarks','i10thObtainedMarks','s10thRollNo','s10thSchoolName','s10thSchoolAddress','s10thSchoolPinCode','s12thPassStatus','s12thYearPassing','S12ThPalceOfSchool','s12thSchoolType','s12thQualifyingState','s12thBoard','s12thResultMode','f12thMarks','i12thTotalMarks','i12thObtainedMarks','s12thRollNo','s12thSchoolName','s12thSchoolAddress','s12thSchoolPinCode','sNameOfEntranceExam','sMonthOfPassing','	fMarksObtained','	fPercentileObtained','sAIR','sCategoryRank','iBisActive', 
            'sOtherDetails1', 'sOtherDetails2', 'sOtherDetails3', 'sOtherDetails4','sOtherDetails5'
        ]);
         $data['dtUpdatedDate'] = now();
 
         // Update student data in the database using DB::table()
         DB::table('tblQualificationOfStudents')
             ->where('iId', $id)
             ->update($data);  // Use update() method to update student data
 
         // Return success response
         return response()->json([
             'message' => 'Student updated successfully',
             'data' => $data,
             'result'=>'3'
         ]);
     }
 
 
 
 
 
     // Delete student profile (Delete)
     public function deleteQualificationOfStudents($id)
     {
         // Find student by ID using DB::table()
         $student = DB::table('tblQualificationOfStudents')
             ->where('iId', $id)
             ->first();  // Check if student exists
 
         if (!$student) {
             // Return error if student not found
             return response()->json([
                 'message' => 'Student Qualification not found',
                 'result' => '5'
             ]);
         }
 
         // Delete student profile from the database using DB::table()
         DB::table('tblQualificationOfStudents')
             ->where('iId', $id)
             ->delete();  // Use delete() to remove the record
 
         // Return success response
         return response()->json([
             'message' => 'Student Qualification deleted successfully',
             'result' => '4'
         ]);
     }

     

     
    // Get Qualification of student by ID (Read)
    public function getQualificationByStudentId($id)
    {
        // Find student by ID using DB::table() 
        $student = DB::table('tblQualificationOfStudents')
            ->where('iStudentId', $id)
            ->first();  // Using first() to get a single result

        if (!$student) {
            // Return error if student not found
            return response()->json([
                'message' => 'Student Qualification not found'
            ]);
        }
        $studentArray = (array) $student;
        // Return student data
        return response()->json([
            'data' => [$studentArray], // Wrapping in an array
            'result' => '1'
        ]);   
    
    }


}
