<?php
namespace App\Http\Controllers\App;

use Illuminate\Support\Facades\Schema;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;

class SubscriptionController extends Controller
{



    // Add new payment record (Create)
    public function addSubscription(Request $request)
    {
        $request->validate([
            'iStudentId' => 'required|integer',
            'iAmount' => 'required|numeric',
            'sPaymentMode' => 'nullable|string',
            'sRemark' => 'nullable|string',
            'dtUpdatedDate' => 'nullable|date',
            'sOtherDetails1' => 'nullable|string',
            'sOtherDetails2' => 'nullable|string',
            'sOtherDetails3' => 'nullable|string',
            'sOtherDetails4' => 'nullable|string',
        ]);

        // Insert new record into tblSubscription
        $paymentId = DB::table('tblSubscription')->insertGetId([
            'iStudentId' => $request->iStudentId,
            'iAmount' => $request->iAmount,
            'sPaymentMode' => $request->sPaymentMode,
            'sRemark' => $request->sRemark,
            'sOtherDetails1' => $request->sOtherDetails1,
            'sOtherDetails2' => $request->sOtherDetails2,
            'sOtherDetails3' => $request->sOtherDetails3,
            'sOtherDetails4' => $request->sOtherDetails4,
            'iBisActive' => 1,  // ✅ Include this in the insert query
            'dtUpdatedDate' => now(),  // ✅ Include timestamp
        ]);

        // Update the amount in tglRegistration by adding the new subscription amount
        DB::table('tblregistration')
            ->where('iId', $request->iStudentId)
            ->increment('iTotalAmount', $request->iAmount);

        return response()->json([
            'message' => 'Subscription record added and registration amount updated successfully',
            'data' => $paymentId,
            'result' => "1"
        ], 201);
    }






    // Get payment record by ID (Read)
    public function getSubscription($id)
    {
        try {
            $payment = DB::table('tblSubscription')
                ->where('iId', $id)
                ->where('iBisActive', 1)
                ->first();
    
            return response()->json([
                'data' => $payment ? $payment : [], // Return data if found, else empty array
                'result' => "2" // Always return "2" if no error occurs
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'message' => 'An error occurred',
                'error' => $e->getMessage(),
                'result' => "5" // Return "5" in case of an error
            ], 500);
        }
    }
    





    // Get all payment records (Read all)
    public function getAll()
    {

        $payments = DB::table('tblSubscription')->where('iBisActive' , 1)->get();


        return response()->json($payments);
    }






    // Update payment record (Update)
    public function updateSubscription(Request $request)
    {
        // Validate input
        $request->validate([
            'iStudentId' => 'required|integer',
            'iAmount' => 'required|numeric',
            'sPaymentUrl' => 'nullable|string',
            'sStatus' => 'required|string',
            'sFlag' => 'nullable|string',
            'iBisActive' => 'required|boolean',
            'dtUpdatedDate' => 'nullable|date',
            'sOtherDetails1' => 'nullable|string',
            'sOtherDetails2' => 'nullable|string',
            'sOtherDetails3' => 'nullable|string',
            'sOtherDetails4' => 'nullable|string',
        ]);
        $iId =  $request->input('iId');
        $updated = DB::table('tblSubscription')->where('iId', $iId)->update([
            'iStudentId' => $request->iStudentId,
            'iAmount' => $request->iAmount,
            'sPaymentUrl' => $request->sPaymentUrl,
            'sStatus' => $request->sStatus,
            'sFlag' => $request->sFlag,
            'iBisActive' => $request->iBisActive,
            'dtUpdatedDate' => $request->dtUpdatedDate,
            'sOtherDetails1' => $request->sOtherDetails1,
            'sOtherDetails2' => $request->sOtherDetails2,
            'sOtherDetails3' => $request->sOtherDetails3,
            'sOtherDetails4' => $request->sOtherDetails4,
        ]);

        if (!$updated) {
            return response()->json([
                'message' => 'Payment record not found or no changes made'
            ], 404);
        }

        return response()->json([
            'message' => 'Payment record updated successfully'
        ]);
    }




    // Delete payment record (Delete)
    public function deleteSubscription($id)
    {
        // Fetch the subscription record to get the amount and student ID
        $subscription = DB::table('tblSubscription')->where('iId', $id)->first();
    
        if (!$subscription) {
            return response()->json([
                'message' => 'Payment record not found',
                'result' => "0"
            ], 404);
        }
    
        // Subtract the amount from tglRegistration
        DB::table('tblregistration')
            ->where('iId', $subscription->iStudentId)
            ->decrement('iTotalAmount', $subscription->iAmount);
    
        // Delete the subscription record
        DB::table('tblSubscription')->where('iId', $id)->delete();
    
        return response()->json([
            'message' => 'Payment record deleted successfully, amount updated',
            'result' => "4"
        ], 200);
    }
    



    public function getSubscriptionByStudentId($iId)
    {
        // Validate input
        if (!is_numeric($iId)) {
            return response()->json([
                'message' => 'Invalid Student ID',
                'result' => "0"
            ], 400);
        }

        // Fetch subscription data for the given student ID
        $subscription = DB::table('tblSubscription')
            ->where('iStudentId', $iId)
            ->where('iBisActive', 1) // Ensure only active records are fetched
            ->get();

        // Check if data exists
        if ($subscription->isEmpty()) {
            return response()->json([
                'message' => 'No subscription found for this student',
                'result' => "0"
            ]);
        }

        // Return data
        return response()->json([
            'message' => 'Subscription data retrieved successfully',
            'data' => $subscription,
            'result' => "1"
        ], 200);
    }

}


