<?php

namespace App\Http\Controllers\app;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;



class stepForStudentController extends Controller
{



    
    // Add step
    public function addStep(Request $request)
    {
        $data = $request->only([
            'iStudentId','sStep', 'sRemark', 'iBisActive', 'dtUpdatedDate'
        ]);
        $data['dtUpdatedDate'] = now();
        $dta['iBisActive'] =1;
        $id = DB::table('tblStudentAdmissionStep')->insertGetId($data);

        return response()->json(['result'=>'2','message' => 'Step Added Successfully', 'id' => $id], 201);
    }



    // update the step
    public function update(Request $request)
    {
        // Validate the incoming request data
        $validatedData = $request->validate([
            'iId' => 'required|integer', // Ensure iId is provided and is an integer
            'iStudentId' => 'nullable|integer',
            'sStep' => 'nullable|string|max:255',
            'sRemark' => 'nullable|string|max:255',
            'iBisActive' => 'nullable|integer',
        ]);

        $iId = $validatedData['iId']; 
        $record = DB::table('tblStudentAdmissionStep')->where('iId', $iId)->first();

        if (!$record) {
            return response()->json([
                'result' => "4",
                'message' => 'Record not found',
            ], 404); 
        }

        // Prepare the data for update
        $updateData = [
            'iStudentId' => $request->iStudentId ?? $record->iStudentId,
            'sStep' => $request->sStep ?? $record->sStep,
            'sRemark' => $request->sRemark ?? $record->sRemark,
            'iBisActive' => $request->iBisActive ?? $record->iBisActive,
            'dtUpdatedDate' => now(),
        ];

        try {
            DB::table('tblStudentAdmissionStep')->where('iId', $iId)->update($updateData);

            return response()->json([
                'result' => "3",
                'message' => 'Record updated successfully',
                'data' => $updateData,
            ], 200); // 200 OK
        } catch (\Exception $e) {
            return response()->json([
                'result' => "5",
                'message' => 'Error occurred while updating record',
                'error' => $e->getMessage(),
            ], 500); // 500 Internal Server Error
        }
    }




    public function index()
    {
        $activeUsers = DB::table('tblStudentAdmissionStep')->where('iBisActive', 1)->get();

        if ($activeUsers->isEmpty()) {
            return response()->json([
                'result' => 0,
                'message' => 'No active users found',
            ], 404);
        }

        return response()->json([
            'result' => "1",
            'message' => 'Active users retrieved successfully',
            'data' => $activeUsers,
        ], 200);  
    }


}
