<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class JWTMiddleware
{
    public function handle(Request $request, Closure $next)
    {
        try {
            // Parse the token and authenticate user
            $user = JWTAuth::parseToken()->authenticate();

            // ❌ Check if the token in the database matches the one provided in the request
            if (!$user || $user->jwt_token !== JWTAuth::getToken()) {
                return response()->json(['message' => 'Unauthorized. Invalid token.'], 401);
            }
        } catch (TokenExpiredException $e) {
            return response()->json(['message' => 'Token expired. Please log in again.'], 401);
        } catch (TokenInvalidException $e) {
            return response()->json(['message' => 'Invalid token.'], 401);
        } catch (JWTException $e) {
            return response()->json(['message' => 'Token not found.'], 401);
        }

        return $next($request);
    }
}
