<?php

namespace App\Http\Controllers\app;
use Illuminate\Support\Facades\Log;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class ImageUploadController extends Controller
{


    // Upload Images
    public function uploadImage(Request $request)
    {
        $request->validate([
            'image' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048', // Validation rules
        ]);
    
        if ($request->hasFile('image')) {
            $image = $request->file('image');
    
            $imageName = uniqid('_', true) . '.' . $image->getClientOriginalExtension();
    
            $uploadPath = public_path('A2ZAdmission/upload');
    
            if (!file_exists($uploadPath)) {
                mkdir($uploadPath, 0777, true); 
            }
    
            $image->move($uploadPath, $imageName);
    
            $imageUrl = asset('A2ZAdmission/upload/' . $imageName);
    
            return response()->json([
                'result' => 1,
                'success' => true,
                'message' => 'Image uploaded successfully.',
                'image_path' => $imageUrl,
            ]);
        }
    
        return response()->json(['success' => false, 'message' => 'Image upload failed.']);
    }
    


    // Insert Image

    public function insertImg(Request $request)
    {
        // Ensure the input name matches the validation and file handling
        $request->validate([
            'image' => 'required|mimes:jpeg,png,jpg,gif,pdf|max:5120', // Allow images and PDFs, max size 5MB
        ]);
    
        // Check if the correct file input is present in the request
        if ($request->hasFile('image')) {
            $file = $request->file('image'); // Use the 'image' input field
            
            // Log the received file details
            \Log::info('Received file for upload.', ['file_name' => $file->getClientOriginalName()]);
    
            $fileName = $file->getClientOriginalName(); // Keep the original filename
            
            $uploadPath = public_path('A2ZAdmission/upload');
    
            // Create the directory if it doesn't exist
            if (!file_exists($uploadPath)) {
                \Log::info('Directory does not exist, creating directory.', ['upload_path' => $uploadPath]);
                mkdir($uploadPath, 0777, true);
            }
    
            // Move the uploaded file to the desired location
            $file->move($uploadPath, $fileName);
    
            // Log after the file move
            \Log::info('File moved successfully.', ['file_name' => $fileName, 'upload_path' => $uploadPath]);
    
            // Encode URL and remove spaces (or replace them with '%20')
            $fileNameEncoded = urlencode($fileName); // Optionally, use str_replace(' ', '%20', $fileName) for more control
            
            // Generate the URL for the uploaded file with the encoded filename
            $fileUrl = asset('A2ZAdmission/upload/' . $fileNameEncoded);
    
            // Log the generated URL
            \Log::info('Generated file URL.', ['file_url' => $fileUrl]);
    
            // Return success response
            return response()->json([
                'result' => 1,
                'success' => true,
                'message' => 'File uploaded successfully.',
                'image_path' => $fileUrl,
            ]);
        }
    
        // Log the failure reason when no file is uploaded
        \Log::error('File upload failed. No file uploaded.', ['input_name' => 'image']);
    
        return response()->json(['success' => false, 'message' => 'File upload failed.']);
    }
    
}
