<?php
namespace App\Http\Controllers\App;

use Illuminate\Support\Facades\Schema;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;

class SubscriptionController extends Controller
{



    // Add new payment record (Create)
    public function addSubscription(Request $request)
    {
        $request->validate([
            'iStudentId' => 'required|integer',
            'iAmount' => 'required|numeric',
            'sPaymentUrl' => 'nullable|string',
            'sStatus' => 'required|string',
            'sFlag' => 'nullable|string',
            'iBisActive' => 'required|boolean',
            'dtUpdatedDate' => 'nullable|date',
            'sOtherDetails1' => 'nullable|string',
            'sOtherDetails2' => 'nullable|string',
            'sOtherDetails3' => 'nullable|string',
            'sOtherDetails4' => 'nullable|string',
        ]);

        $payment = DB::table('tblSubscription')->insertGetId([
            'iStudentId' => $request->iStudentId,
            'iAmount' => $request->iAmount,
            'sPaymentUrl' => $request->sPaymentUrl,
            'sStatus' => $request->sStatus,
            'sFlag' => $request->sFlag,
            'iBisActive' => $request->iBisActive,
            'dtUpdatedDate' => $request->dtUpdatedDate,
            'sOtherDetails1' => $request->sOtherDetails1,
            'sOtherDetails2' => $request->sOtherDetails2,
            'sOtherDetails3' => $request->sOtherDetails3,
            'sOtherDetails4' => $request->sOtherDetails4,
        ]);

        return response()->json([
            'message' => 'Payment record added successfully',
            'data' => $payment
        ], 201);
    }




    // Get payment record by ID (Read)
    public function getSubscription($id)
    {
        $payment = DB::table('tblSubscription')->where('iId', $id)->first();

        if (!$payment) {
            return response()->json([
                'message' => 'Payment record not found'
            ], 404);
        }

        return response()->json($payment);
    }





    // Get all payment records (Read all)
    public function getAll()
    {

        $payments = DB::table('tblSubscription')->where('iBisActive' , 1)->get();


        return response()->json($payments);
    }






    // Update payment record (Update)
    public function updateSubscription(Request $request)
    {
        // Validate input
        $request->validate([
            'iStudentId' => 'required|integer',
            'iAmount' => 'required|numeric',
            'sPaymentUrl' => 'nullable|string',
            'sStatus' => 'required|string',
            'sFlag' => 'nullable|string',
            'iBisActive' => 'required|boolean',
            'dtUpdatedDate' => 'nullable|date',
            'sOtherDetails1' => 'nullable|string',
            'sOtherDetails2' => 'nullable|string',
            'sOtherDetails3' => 'nullable|string',
            'sOtherDetails4' => 'nullable|string',
        ]);
        $iId =  $request->input('iId');
        $updated = DB::table('tblSubscription')->where('iId', $iId)->update([
            'iStudentId' => $request->iStudentId,
            'iAmount' => $request->iAmount,
            'sPaymentUrl' => $request->sPaymentUrl,
            'sStatus' => $request->sStatus,
            'sFlag' => $request->sFlag,
            'iBisActive' => $request->iBisActive,
            'dtUpdatedDate' => $request->dtUpdatedDate,
            'sOtherDetails1' => $request->sOtherDetails1,
            'sOtherDetails2' => $request->sOtherDetails2,
            'sOtherDetails3' => $request->sOtherDetails3,
            'sOtherDetails4' => $request->sOtherDetails4,
        ]);

        if (!$updated) {
            return response()->json([
                'message' => 'Payment record not found or no changes made'
            ], 404);
        }

        return response()->json([
            'message' => 'Payment record updated successfully'
        ]);
    }






    // Delete payment record (Delete)
    public function deleteSubscription($id)
    {
        $deleted = DB::table('tblSubscription')->where('iId', $id)->delete();

        if (!$deleted) {
            return response()->json([
                'message' => 'Payment record not found'
            ], 404);
        }

        return response()->json([
            'message' => 'Payment record deleted successfully'
        ]);
    }
}


