<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;




class SlotController extends Controller
{
    
    // Add  slot 
    public function addSlot(Request $request)
    {
        $data = $request->only([
            'dtSlotDate','sStartTime', 'sEndTime', 'iNoOfStudents', 'iReamaining', 'sRemark','iBisActive', 
            'dtUpdatedDate'
        ]);
        $data['dtUpdatedDate'] = now();
        $data['iBisActive'] =1;
        $id = DB::table('tblSlot')->insertGetId($data);

        return response()->json(['result'=>'2','message' => 'Slot added Successfully', 'id' => $id], 201);
    }


    // Update slot Booking
    public function updateSlot(Request $request)
    {
        $data = $request->only([
           'dtSlotDate','sStartTime', 'sEndTime', 'iNoOfStudents', 'iReamaining', 'iBisActive', 
            'dtUpdatedDate', 'sRemark'
        ]);

        $iId = $request->input('iId');
        $data['dtUpdatedDate']=now();
        $updated = DB::table('tblSlot')->where('iId', $iId)->update($data);

        if ($updated) {
            return response()->json(['result'=>'3','message' => 'Slot updated Successfully']);
        } else {
            return response()->json(['message' => 'Slot Failed to update'], 404);
        }
    }



    // Delete a record
    public function deleteSlot($iId)
    {
        $deleted = DB::table('tblSlot')->where('iId', $iId)->update(['iBisActive' => 0]);
        if ($deleted) {
            return response()->json(['result'=>'2','message' => ' Slot deleted']);
        } else {
            return response()->json(['result'=>'2','message' => ' Slot not found']);
        }
    }


    // get all slot Booking
    public function getAllSlot()
    {
        $slotbooking=DB::table('tblSlot')
        ->select('tblSlot.*')
        ->where('tblSlot.iBisActive', 1)
        ->get();
        return response()->json(['result'=>'1','data'=>$slotbooking]);                                                                                                                                 
    }



    // get slotbooking by studentid
    public function getSlotById($iId)
    {
        $institute = DB::table('tblSlot')
        ->where([
            ['iId', '=', $iId],          
            ['iBisActive', '=', 1],    
        ])
        ->first();
            
        if ($institute) {
            return response()->json([
                'result' => '1', 
                'message' => 'Slot  found successfully',
                'data' => $institute, 
            ]);
        } else {
            return response()->json([
                'result' => '5',
                'message' => 'Slot  not found',
            ], 404);
        }
    }



    //get slot by date
    public function getSlotByDate(Request $request)
    {
        $date = $request->only(['dtSlotDate']);
        $institute = DB::table('tblSlot')
        ->where([
            ['dtSlotDate', '=', $date],          
            ['iBisActive', '=', 1],    
        ])
        ->get();
            
        if ($institute) {
            return response()->json([
                'result' => '1', 
                'message' => 'Slot found successfully',
                'data' => $institute, 
            ]);
        } else {
            return response()->json([
                'result' => '5',
                'message' => 'Slot  not found',
            ], 404);
        }
    }




    // get slots for
    public function getSlotForWeek()
    {
        // Get the current date and time
        $currentDate = now()->format('Y-m-d'); // Today's date (YYYY-MM-DD)
        $currentTime = now()->format('H:i:s'); // Current time (HH:MM:SS)
        $endDate = now()->addDays(7)->format('Y-m-d'); // 7 days from today
    
        // Fetch slots with necessary filtering
        $slotbooking = DB::table('tblSlot')
            ->leftJoin('tblSlotBooking', 'tblSlot.iId', '=', 'tblSlotBooking.iSlotId') // Join slots with bookings
            ->select(
                'tblSlot.iId as iSlotId',
                'tblSlot.dtSlotDate',     
                'tblSlot.sStartTime',    
                'tblSlot.sEndTime',     
                'tblSlot.iNoOfStudents', 
                'tblSlot.sRemark',
                DB::raw('COALESCE(COUNT(tblSlotBooking.iSlotId), 0) as totalBooked'), // Total students booked
                DB::raw('(tblSlot.iNoOfStudents - COALESCE(COUNT(tblSlotBooking.iSlotId), 0)) as remainingCapacity') // Remaining capacity
            )
            ->where('tblSlot.iBisActive', 1) // Active slots only
            ->whereBetween('tblSlot.dtSlotDate', [$currentDate, $endDate]) // Filter slots for the next 7 days
            ->where(function ($query) use ($currentDate, $currentTime) {
                $query->where(function ($subQuery) use ($currentDate, $currentTime) {
                    $subQuery->whereDate('tblSlot.dtSlotDate', $currentDate)
                             ->whereTime('tblSlot.sStartTime', '>=', $currentTime); // Today's slots should be upcoming
                })
                ->orWhere(function ($subQuery) use ($currentDate) {
                    $subQuery->whereDate('tblSlot.dtSlotDate', '>', $currentDate); // Future slots
                });
            })
            ->groupBy(
                'tblSlot.iId',             
                'tblSlot.dtSlotDate',      
                'tblSlot.sStartTime',      
                'tblSlot.sEndTime',        
                'tblSlot.iNoOfStudents',   
                'tblSlot.iBisActive',
                'tblSlot.sRemark'
            )
            ->havingRaw('remainingCapacity > 0') // Only slots with available capacity
            ->orderBy('tblSlot.dtSlotDate', 'asc') 
            ->orderBy('tblSlot.sStartTime', 'asc') 
            ->get();
    
        return response()->json(['result' => '1', 'data' => $slotbooking]);
    }
    



    // get Slots for book
    public function getslotsforbook()
    {
        // Get the current date and time
        $currentDate = now()->format('Y-m-d'); // Current date in 'Y-m-d'
        $currentTime = now()->format('H:i:s'); // Current time in 'H:i:s'
    
        // Fetch slots with necessary filtering
        $slotbooking = DB::table('tblSlot')
            ->leftJoin('tblSlotBooking', 'tblSlot.iId', '=', 'tblSlotBooking.iSlotId') // Join slots with bookings
            ->select(
                'tblSlot.iId as iSlotId',
                'tblSlot.dtSlotDate',     
                'tblSlot.sStartTime',    
                'tblSlot.sEndTime',     
                'tblSlot.iNoOfStudents', 
                'tblSlot.sRemark',
                DB::raw('COALESCE(COUNT(tblSlotBooking.iSlotId), 0) as totalBooked'), // Total students booked for each slot
                DB::raw('(tblSlot.iNoOfStudents - COALESCE(COUNT(tblSlotBooking.iSlotId), 0)) as remainingCapacity')
            )
            ->where('tblSlot.iBisActive', 1) 
            ->where(function ($query) use ($currentDate, $currentTime) {
                $query->where(function ($subQuery) use ($currentDate, $currentTime) {
                    $subQuery->whereDate('tblSlot.dtSlotDate', $currentDate)
                             ->whereTime('tblSlot.sStartTime', '>=', $currentTime);
                })
                ->orWhere(function ($subQuery) use ($currentDate) {
                    $subQuery->whereDate('tblSlot.dtSlotDate', '>', $currentDate);
                });
            })
            ->groupBy(
                'tblSlot.iId',             
                'tblSlot.dtSlotDate',      
                'tblSlot.sStartTime',      
                'tblSlot.sEndTime',        
                'tblSlot.iNoOfStudents',   
                'tblSlot.iReamaining',     
                'tblSlot.dtUpdatedDate',   
                'tblSlot.iBisActive',      
                'tblSlot.sOtherDetails1',  
                'tblSlot.sOtherDetails2',
                'tblSlot.sOtherDetails3',
                'tblSlot.sOtherDetails4'
            )
            ->havingRaw('remainingCapacity > 0') 
            ->orderBy('tblSlot.dtSlotDate', 'asc') 
            ->orderBy('tblSlot.sStartTime', 'asc') 
            ->get();
    
        return response()->json(['result' => '1', 'data' => $slotbooking]);
    }
    

}
