
<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Admin\InstituteController;
use App\Http\Controllers\Admin\AdminUserController;
use App\Http\Controllers\App\appUserController;
use App\Http\Controllers\Admin\cutOffController;
use App\Http\Controllers\App\ImageUploadController;
use App\Http\Controllers\App\stepForStudentController;
use App\HTTp\Controllers\Admin\programStepController;
use App\Http\Controllers\Admin\SlotController;
use App\Http\Controllers\App\SlotBookingController; 
use App\Http\Controllers\Admin\SeatMatrixController;
use App\Http\Controllers\Admin\ConsellingPackageController;
use App\Http\Controllers\App\SubscriptionController;
use App\Http\Controllers\App\ProfileController;
use App\Http\Controllers\Admin\AppPackageController;
use App\Http\Controllers\App\StudentQualificationController;
use App\Http\Controllers\App\StudentCategotyController;


Route::get('/', function () {
    return view('welcome');
});




// App Routes
Route::prefix('app')->group(function () {

    // USER 
    Route::controller(appUserController::class)->group(function () {
        Route::get('/registrations', 'index');             // List all registrations
        Route::get('/registrations/{id}', 'show');         // Get a specific registration
        Route::post('/registrations', 'store');           // Add a new registration
        Route::put('/registrations', 'update');     // Update a registration
        Route::delete('/registrations/{iId}', 'destroy'); // Delete a registration
        Route::post('/login', 'login');                    // User login
        Route::post('/forget-password', 'forgetPassword'); // Forgot password
        Route::post('/reset-password', 'resetPassword');   // Reset password
        Route::post('/updateRegistration', 'updateRegistration');   // Update Images
        Route::post('/getFilteredRegistrations', 'getFilteredRegistrations');   // Update Images

    });



    // Institute
    Route::controller(InstituteController::class)->group(function () {
        Route::get('/paginated', 'getPaginatedColleges');//get colleges by page
        Route::get('/institutes/{iId}', 'show');      // Get a specific institute
        Route::get('/searchInstitute', 'search');     // Get Search list
        Route::get('/sortInstitute', 'getColleges');     // Get sort list
        Route::get('/getStates', 'getStates');     // Get distinct states
        Route::get('/getCities', 'getCities');     // Get distinct cities
        Route::post('/getDistrictsByFilter', 'getDistrictsByFilter');     // Get district by selected states
        Route::get('/getProgram', 'getProgram');     // Get distinct programs
        Route::post('/getProgramsByFilter', 'getProgramsByFilter');     // Get programs by selected cities
        Route::get('/getCourse', 'getCourse');     // Get distinct course
        Route::post('/getCoursesByfilter', 'getCoursesByfilter');     // Get programs by selected cities
        Route::get('/getStatus', 'getStatus');     // Get distinct status
        Route::get('/getBranchName', 'getBranchName');     // Get distinct branch
        Route::post('/getBranchByCourseAndProgram', 'getBranchByCourseAndProgram');     // Get branch by program and course
        Route::post('/getStatusByfilter', 'getStatusByfilter');     // Get programs by selected cities
        Route::post('/getCollegesByFilters', 'getCollegesByFilters');     // Get colleges by filter options
        Route::post('/getCollegesByFilter', 'getCollegesByFilter');     // Get colleges by filter , sort and
        Route::post('/getCoursesByProgram', 'getCoursesByProgram');     // Get colleges by filter course options 
        Route::post('/getBranchByFilter', 'getBranchByFilter');     // Get colleges by filter course options 



    });


    // Cut Off Institute
    Route::controller(cutOffController::class)->group(function(){
        route::get('/getAllCutOffList','getAllCutOffList'); //get cut off list
        Route::get('/getCutOffByid/{id}', 'getCutOffByid'); //get cutoff by id
        Route::post('/getAllCutOffListbyPage', 'getAllCutOffListbyPage'); //get cutoff by paging
        Route::post('/getAllCutOffByFilter','getAllCutOffByFilter'); //get cut off by filter
        Route::get('/getStatesByCutOff','getStatesByCutOff'); // get distinct states
        Route::post('/getDistrictsBystate','getDistrictsBystate'); //get distinct District
        Route::post('/getProgramsByCutOffFilter','getProgramsByCutOffFilter'); //get distinct Progrmas
        Route::post('/getCoursesByCutOffFilter','getCoursesByCutOffFilter'); //get distinct courses
        Route::post('/getStatusByCutOffFilter','getStatusByCutOffFilter'); //get distinct Status
        Route::post('/getBranchByCutOffFilter', 'getBranchByCutOffFilter');     // Get Branch by filter course options 
        Route::post('/getRound', 'getRoundByCutOffFilter');     // Get Branch by filter course options 
        Route::post('/getAirRangeByCutOffFilter', 'getAirRangeByCutOffFilter');     // Get air rank by filter course options 
        Route::post('/getSMLRangeByCutOffFilter', 'getSMLRangeByCutOffFilter');     // Get Sml rank by filter course options 


    });


    // Image Upload
    Route::controller(ImageUploadController::class)->group(function(){
        Route::post('/uploadImage', 'uploadImage'); //To upload image in upload folder

    });


    // Steps of Student
    Route::controller(stepForStudentController::class)->group(function(){
        Route::post('/addStep', 'addStep'); //add step

    });


    // ProgramWise Process Steps
    Route::controller(programStepController::class)->group(function(){

        Route::post('/getStepsByProgramAndYear', 'getStepsByProgramAndYear'); //Show process steps according to program
    });


    
    // Slot
    Route::controller(SlotController::class)->group(function(){

        Route::post('/getSlotByDate', 'getSlotByDate'); //get slot by date
        Route::get('/getAllSlot', 'getAllSlot'); //get all slot
        Route::get('/getslotsforbook', 'getslotsforbook'); //get all slot
        Route::get('/getSlotForWeek', 'getSlotForWeek'); //get slot by date


    });




     // Book Slot
     Route::controller(SlotBookingController::class)->group(function(){

        Route::post('/addSlotBooking', 'addSlotBooking'); //add slot Booking
        Route::put('/updateSlotBooking', 'updateSlotBooking'); //update slot Booking
        Route::delete('/deleteSlotBooking/{id}', 'deleteSlotBooking'); //delete slot Booking
        Route::get('/getAllSlotBooking', 'getAllSlotBooking'); //get all slot Booking
        Route::get('/getSlotBookingByStudentId/{id}', 'getSlotBookingByStudentId'); //get booked slot by studentid

    });



      // Seat Matrix
      Route::controller(SeatMatrixController::class)->group(function () {
      
        Route::post('/getSeatMatrices', 'getSeatMatrices'); //get matrices according to filter
        Route::post('/getDistinctQuota', 'getDistinctQuota'); //get distinct quota
        Route::post('/getDistinctState', 'getDistinctState'); //get distinct state
        Route::post('/getDistinctCourseNames', 'getDistinctCourseNames'); //get distinct course
        Route::get('/getDistinctRound', 'getDistinctRound'); //get distinct round
        Route::get('/getSeatMatricesAll', 'getSeatMatricesAll'); //get distinct round

    });



     // Subscripation
     Route::controller(SubscriptionController::class)->group(function () {
         Route::post('/addSubscription', 'addSubscription'); // Add Subscription
         Route::get('/getSubscription/{id}', 'getSubscription'); // Get a specific subscription
         Route::get('/getAll', 'getAll'); // Get all subscriptions
         Route::put('/updateSubscription', 'updateSubscription'); // Update a subscription
         Route::delete('/deleteSubscription/{id}', 'deleteSubscription'); // Delete subscription
     });
     



      // Profile  details
      Route::controller(ProfileController::class)->group(function () {
        Route::post('/addProfile', 'addProfile'); // Add Profile Details
        Route::get('/getProfile/{id}', 'getProfile'); // Get a specific Profile Details
        Route::get('/getAllProfile', 'getAllProfile'); // Get all Profile Details
        Route::put('/updateProfile', 'updateProfile'); // Update a Profile Details
        Route::delete('/deleteProfile/{id}', 'deleteProfile'); // Delete Profile Details
        Route::get('/getProfileBystudentId/{id}', 'getProfileBystudentId'); // Get a specific Profile Details

    });



    // Conselling Package
    Route::controller(ConsellingPackageController::class)->group(function () {
       
        Route::get('/getAllPackages', 'getAllPackages'); //get all packages
        Route::get('/getPackage/{id}', 'getPackage'); //get all packages
    }); 




    // Student Qualification details 
    Route::controller(StudentQualificationController::class)->group(function () {
       
        Route::post('/addQualificationOfStudents', 'addQualificationOfStudents'); // Add Profile Details
        Route::get('/getQualification/{id}', 'getQualification'); // Get a specific Profile Details
        Route::get('/getAllQualificationOfStudents', 'getAllQualificationOfStudents'); // Get all Profile Details
        Route::put('/updateQualificationOfStudents', 'updateQualificationOfStudents'); // Update a Profile Details
        Route::delete('/deleteQualificationOfStudents/{id}', 'deleteQualificationOfStudents'); // Delete Profile Details
        Route::get('/getQualificationByStudentId/{id}', 'getQualificationByStudentId'); // Get a specific Qualification Details

    });




   // Student Category details 
   Route::controller(StudentCategotyController::class)->group(function () {
       
    Route::post('/addCategoryOfStudents', 'addCategoryOfStudents'); // Add category of students Details
    Route::get('/getCategoryOfStudentsById/{id}', 'getCategoryOfStudentsById'); // Get a specific category of students Details
    Route::get('/getAllCategoryOfStudents', 'getAllCategoryOfStudents'); // Get all category of students Details
    Route::put('/updateCategoryOfStudents', 'updateCategoryOfStudents'); // Update a category of students Details
    Route::delete('/deleteCategoryOfStudents/{id}', 'deleteCategoryOfStudents'); // Delete category of students Details
    Route::get('/getCategoryByStudentId/{id}', 'getCategoryByStudentId'); // Get a specific category of students Details

   }); 
   
   

    // Package Counselling
    Route::controller(ConsellingPackageController::class)->group(function () {
        
        Route::get('/getAllPackages', 'getAllPackages'); //get all packages
        
    });    



    Route::controller(AppPackageController::class)->group(function () {
    
        Route::get('/getAllAppPackages', 'getAllAppPackages'); //get all packages conselling

    }); 

});






// Admin Routes
Route::prefix('admin')->group(function () {


    // Institutes Management
    Route::controller(InstituteController::class)->group(function () {
        Route::get('/institutes', 'index');            // List all institutes
        Route::post('/institutes', 'store');           // Add a new institute
        Route::put('/institutes', 'update');           // Update an institute
        Route::delete('/institutes/{iId}', 'destroy'); // Delete an institute
        Route::get('/paginated', 'getPaginatedColleges'); // Get colleges by page
        Route::post('/addInstitutes', 'addInstitutes'); // Add a new institute
        Route::get('/getProgram', 'getProgram');     // Get distinct programs

    });



    // Users Management
    Route::controller(AdminUserController::class)->group(function () {
        Route::post('/users', 'store');              // Add a new user
        Route::put('/users', 'update');              // Update an existing user
        Route::delete('/users/{id}', 'destroy');     // Delete users by id
        Route::get('/users', 'index');              // Get all Users
        Route::post('/loginAdmin', 'loginAdminUser'); // Admin login
        Route::post('/changePassword', 'changePassword'); // Admin login
    });




    // USER
    Route::controller(appUserController::class)->group(function () {
        Route::get('/registrations', 'index'); // List all registrations
        Route::post('/getFilteredRegistrations', 'getFilteredRegistrations');   // get users by filter
        Route::post('/registrations', 'store');           // Add a new registration
        Route::put('/registrations', 'update');     // Update a registration
        Route::delete('/registrations/{iId}', 'destroy'); // Delete a registration

    });



    // Cut Off Institute
    Route::controller(cutOffController::class)->group(function () {
        Route::post('/addCutOff', 'addCutOff');             // Add Cut Off
        Route::post('/addMultipleCutOff', 'addMultipleCutOff'); // Add Multiple Cut Off
        Route::put('/updateCutOffList', 'updateCutOffList'); // Update Cut Off
        Route::delete('/deleteCutOff/{id}', 'deleteCutOff'); // Delete Cut Off
        Route::get('/getCutOffByid/{id}', 'getCutOffByid'); // Get Cut Off by ID
        route::get('/getAllCutOffList','getAllCutOffList'); //get cut off list
        Route::post('/getRound', 'getRoundByCutOffFilter');     // Get Branch by filter course options 

    });



    // Program Step
    Route::controller(programStepController::class)->group(function(){
        Route::post('/addProgramStep', 'addProgramStep');  //Add Program steps
        Route::put('/updateProgramStep', 'updateProgramStep');  //Update Program Steps
        Route::get('/getAllProgramSteps', 'getAllProgramSteps');  // Get all ProgramSteps
        Route::delete('/deleteAdmissionStep/{id}', 'deleteAdmissionStep'); // Delete Cut Off


    });



    // Image Upload
    Route::controller(ImageUploadController::class)->group(function(){
        Route::post('/insertImg', 'insertImg');  //Insert image in upload Folder
    });


    
    // Slot
    Route::controller(SlotController::class)->group(function(){

        Route::post('/addSlot', 'addSlot'); //Add Slot
        Route::put('/updateSlot', 'updateSlot'); //Update slot 
        Route::delete('/deleteSlot/{id}', 'deleteSlot'); //delete slot
        Route::get('/getAllSlot', 'getAllSlot'); //get all slot
        Route::post('/getSlotById/{id}','getSlotById'); //get all slot by id
        Route::get('/getslotsforbook', 'getslotsforbook'); //get all slot
        Route::post('/getSlotByDate', 'getSlotByDate'); //get slot by date

    });


    

    // Seat Matrix
     Route::controller(SeatMatrixController::class)->group(function () {
        Route::post('/addSeatMatrix', 'addSeatMatrix'); // Add Single Seat Matrix
        Route::post('/addMultipleSeatMatrices', 'addMultipleSeatMatrices'); //Add Multiple seat matrices
        Route::post('/getSeatMatrices', 'getSeatMatrices'); //Add Multiple seat matrices
        Route::get('/getSeatMatricesAll', 'getSeatMatricesAll'); //get distinct round
        Route::put('/updateSeatMatrix', 'updateSeatMatrix'); //get distinct round
        Route::delete('/deleteSeatMatrix/{id}', 'deleteSeatMatrix'); //get distinct round


    });



    // Package Counselling
    Route::controller(ConsellingPackageController::class)->group(function () {
        Route::post('/addPackage', 'addPackage'); // Add Single package counselling
        Route::post('/addMultiplePackages', 'addMultiplePackages'); // Add Multiple package counselling
        Route::put('/updateCounsellingPackage', 'updateCounsellingPackage'); //update package counselling
        Route::get('/getAllPackages', 'getAllPackages'); //get all packages
        Route::get('/getDisProgram', 'getDisProgram'); //get all packages
        Route::get('/getPackage/{id}', 'getPackage'); //get all packages
        Route::delete('/deleteCounsellingPackage/{id}', 'deleteCounsellingPackage'); //get all packages

        
    });    



    Route::controller(AppPackageController::class)->group(function () {
        Route::post('/addAppPackage', 'addAppPackage'); // Add Single package counselling
        Route::put('/UpdateAppPackage', 'UpdateAppPackage'); //update package counselling
        Route::get('/getAllAppPackages', 'getAllAppPackages'); //get all packages
        Route::get('/getAppPackage/{id}', 'getAppPackage'); //get all packages
        Route::delete('/deleteAppPackage/{id}', 'deleteAppPackage'); //get all packages
        Route::post('/addMultipleAppPackages', 'addMultipleAppPackages'); // Add Multiple package counselling

    });    


   // Student Qualification details 
   Route::controller(StudentQualificationController::class)->group(function () {
       
    Route::post('/addQualificationOfStudents', 'addQualificationOfStudents'); // Add Qualification Details
    Route::get('/getQualification/{id}', 'getQualification'); // Get a specific Qualification Details
    Route::get('/getAllQualificationOfStudents', 'getAllQualificationOfStudents'); // Get all Qualification Details
    Route::put('/updateQualificationOfStudents', 'updateQualificationOfStudents'); // Update a Qualification Details
    Route::delete('/deleteQualificationOfStudents/{id}', 'deleteQualificationOfStudents'); // Delete Qualification Details
    Route::get('/getAllQualificationOfStudents', 'getAllQualificationOfStudents'); // Get all Qualification Details
    Route::get('/getQualificationByStudentId/{id}', 'getQualificationByStudentId'); // Get a specific Qualification Details

   });


   // Student Category details 
   Route::controller(StudentCategotyController::class)->group(function () {
       
    Route::post('/addCategoryOfStudents', 'addCategoryOfStudents'); // Add category of students Details
    Route::get('/getCategoryOfStudentsById/{id}', 'getCategoryOfStudentsById'); // Get a specific category of students Details
    Route::get('/getAllCategoryOfStudents', 'getAllCategoryOfStudents'); // Get all category of students Details
    Route::put('/updateCategoryOfStudents', 'updateCategoryOfStudents'); // Update a category of students Details
    Route::delete('/deleteCategoryOfStudents/{id}', 'deleteCategoryOfStudents'); // Delete category of students Details
    Route::get('/getCategoryByStudentId/{id}', 'getCategoryByStudentId'); // Get a specific category of students Details

   }); 


   // Book Slot
   Route::controller(SlotBookingController::class)->group(function(){
        Route::post('/addSlotBooking', 'addSlotBooking'); //add slot Booking
        Route::put('/updateSlotBooking', 'updateSlotBooking'); //update slot Booking
        Route::delete('/deleteSlotBooking/{id}', 'deleteSlotBooking'); //delete slot Booking
        Route::get('/getAllSlotBooking', 'getAllSlotBooking'); //get all slot Booking
        Route::get('/getSlotBookingByStudentId/{id}', 'getSlotBookingByStudentId'); //get booked slot by studentid
        Route::post('/getSlotBookedByDate', 'getSlotBookedByDate'); //add slot Booking

    
   });



    // Subscripation
    Route::controller(SubscriptionController::class)->group(function () {
        Route::post('/addSubscription', 'addSubscription'); // Add Subscription
        Route::get('/getSubscription/{id}', 'getSubscription'); // Get a specific subscription
        Route::get('/getAll', 'getAll'); // Get all subscriptions
        Route::put('/updateSubscription', 'updateSubscription'); // Update a subscription
        Route::delete('/deleteSubscription/{id}', 'deleteSubscription'); // Delete subscription
        Route::get('/getSubscriptionByStudentId/{iId}', 'getSubscriptionByStudentId');

    });



  // Profile  details
    Route::controller(ProfileController::class)->group(function () {
            Route::post('/addProfile', 'addProfile'); // Add Profile Details
            Route::get('/getProfile/{id}', 'getProfile'); // Get a specific Profile Details
            Route::get('/getAllProfile', 'getAllProfile'); // Get all Profile Details
            Route::put('/updateProfile', 'updateProfile'); // Update a Profile Details
            Route::delete('/deleteProfile/{id}', 'deleteProfile'); // Delete Profile Details
            Route::get('/getProfileBystudentId/{id}', 'getProfileBystudentId'); // Get a specific Profile Details
    
    });

});

